		/*
		 *
		 * Copyright (C) 2011 - 2018 BMW Car IT GmbH
		 *
		 * Licensed under the Apache License, Version 2.0 (the "License");
		 * you may not use this file except in compliance with the License.
		 * You may obtain a copy of the License at
		 *
		 *      http://www.apache.org/licenses/LICENSE-2.0
		 *
		 * Unless required by applicable law or agreed to in writing, software
		 * distributed under the License is distributed on an "AS IS" BASIS,
		 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		 * See the License for the specific language governing permissions and
		 * limitations under the License.
		 */
		
		// #####################################################
		//#######################################################
		//###                                                 ###
		//##    WARNING: This file is generated. DO NOT EDIT   ##
		//##             All changes will be lost!             ##
		//###                                                 ###
		//#######################################################
		// #####################################################

package joynr.types;
import java.io.Serializable;

import io.joynr.subtypes.JoynrType;

import joynr.types.DiscoveryEntry;
import joynr.types.ProviderQos;
import joynr.types.Version;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;

// NOTE: serialVersionUID is not defined since we don't support Franca versions right now.
//       The compiler will generate a serialVersionUID based on the class and its members
//       (cf. http://docs.oracle.com/javase/6/docs/platform/serialization/spec/class.html#4100),
//       which is probably more restrictive than what we want.

/**
 * Used for lookups between libjoynr and a cluster controller. Contains additional information
 */
@SuppressWarnings("serial")
public class DiscoveryEntryWithMetaInfo extends DiscoveryEntry implements Serializable, JoynrType {
	public static final int MAJOR_VERSION = 0;
	public static final int MINOR_VERSION = 0;
	@JsonProperty("isLocal")
	private Boolean isLocal;

	/**
	 * Default Constructor
	 */
	public DiscoveryEntryWithMetaInfo() {
		this.isLocal = false;
	}

	/**
	 * Copy constructor
	 *
	 * @param discoveryEntryWithMetaInfoObj reference to the object to be copied
	 */
	public DiscoveryEntryWithMetaInfo(DiscoveryEntryWithMetaInfo discoveryEntryWithMetaInfoObj) {
		super(discoveryEntryWithMetaInfoObj);
		this.isLocal = discoveryEntryWithMetaInfoObj.isLocal;
	}

	/**
	 * Parameterized constructor
	 *
	 * @param providerVersion semantic version information
	 * @param domain the domain to register the provider with
	 * @param interfaceName the name of the provider interface
	 * @param participantId the participant ID of the provider
	 * @param qos the qos of the provider
	 * @param lastSeenDateMs the date in millis since epoch when the source for this provider last contacted the directory
	 * @param expiryDateMs the date in millis since epoch when this entry can be purged from the directory and caches
	 * @param publicKeyId the ID of the public key to be used to encrypt messages to this provider
	 * @param isLocal Indicates whether a provider is registered at the local cluster controller
	 */
	public DiscoveryEntryWithMetaInfo(
		Version providerVersion,
		String domain,
		String interfaceName,
		String participantId,
		ProviderQos qos,
		Long lastSeenDateMs,
		Long expiryDateMs,
		String publicKeyId,
		Boolean isLocal
		) {
		super(
				providerVersion,
				domain,
				interfaceName,
				participantId,
				qos,
				lastSeenDateMs,
				expiryDateMs,
				publicKeyId
		);
		this.isLocal = isLocal;
	}

	/**
	 * Gets IsLocal
	 *
	 * @return Indicates whether a provider is registered at the local cluster controller
	 */
	@JsonIgnore
	public Boolean getIsLocal() {
		return isLocal;
	}

	/**
	 * Sets IsLocal
	 *
	 * @param isLocal Indicates whether a provider is registered at the local cluster controller
	 */
	@JsonIgnore
	public void setIsLocal(Boolean isLocal) {
		if (isLocal == null) {
			throw new IllegalArgumentException("setting isLocal to null is not allowed");
		}
		this.isLocal = isLocal;
	}


	/**
	 * Stringifies the class
	 *
	 * @return stringified class content
	 */
	@Override
	public String toString() {
		return "DiscoveryEntryWithMetaInfo ["
		+ super.toString() + ", "
		+ "isLocal=" + this.isLocal
		+ "]";
	}

	/**
	 * Check for equality
	 *
	 * @param obj Reference to the object to compare to
	 * @return true, if objects are equal, false otherwise
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		if (!super.equals(obj))
			return false;
		DiscoveryEntryWithMetaInfo other = (DiscoveryEntryWithMetaInfo) obj;
		if (this.isLocal == null) {
			if (other.isLocal != null) {
				return false;
			}
		} else if (!this.isLocal.equals(other.isLocal)){
			return false;
		}
		return true;
	}

	/**
	 * Calculate code for hashing based on member contents
	 *
	 * @return The calculated hash code
	 */
	@Override
	public int hashCode() {
		int result = super.hashCode();
		final int prime = 31;
		result = prime * result + ((this.isLocal == null) ? 0 : this.isLocal.hashCode());
		return result;
	}
}

	
