		/*
		 *
		 * Copyright (C) 2011 - 2018 BMW Car IT GmbH
		 *
		 * Licensed under the Apache License, Version 2.0 (the "License");
		 * you may not use this file except in compliance with the License.
		 * You may obtain a copy of the License at
		 *
		 *      http://www.apache.org/licenses/LICENSE-2.0
		 *
		 * Unless required by applicable law or agreed to in writing, software
		 * distributed under the License is distributed on an "AS IS" BASIS,
		 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		 * See the License for the specific language governing permissions and
		 * limitations under the License.
		 */
		
		// #####################################################
		//#######################################################
		//###                                                 ###
		//##    WARNING: This file is generated. DO NOT EDIT   ##
		//##             All changes will be lost!             ##
		//###                                                 ###
		//#######################################################
		// #####################################################

package joynr.types;
import java.io.Serializable;

import io.joynr.subtypes.JoynrType;

import joynr.types.DiscoveryScope;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;

// NOTE: serialVersionUID is not defined since we don't support Franca versions right now.
//       The compiler will generate a serialVersionUID based on the class and its members
//       (cf. http://docs.oracle.com/javase/6/docs/platform/serialization/spec/class.html#4100),
//       which is probably more restrictive than what we want.

/**
 * Discovery quality of service settings
 */
@SuppressWarnings("serial")
public class DiscoveryQos implements Serializable, JoynrType {
	public static final int MAJOR_VERSION = 0;
	public static final int MINOR_VERSION = 0;
	@JsonProperty("cacheMaxAge")
	private Long cacheMaxAge;
	@JsonProperty("discoveryTimeout")
	private Long discoveryTimeout;
	@JsonProperty("discoveryScope")
	private DiscoveryScope discoveryScope;
	@JsonProperty("providerMustSupportOnChange")
	private Boolean providerMustSupportOnChange;

	/**
	 * Default Constructor
	 */
	public DiscoveryQos() {
		this.cacheMaxAge = 0L;
		this.discoveryTimeout = 0L;
		this.discoveryScope = DiscoveryScope.LOCAL_ONLY;
		this.providerMustSupportOnChange = false;
	}

	/**
	 * Copy constructor
	 *
	 * @param discoveryQosObj reference to the object to be copied
	 */
	public DiscoveryQos(DiscoveryQos discoveryQosObj) {
		this.cacheMaxAge = discoveryQosObj.cacheMaxAge;
		this.discoveryTimeout = discoveryQosObj.discoveryTimeout;
		this.discoveryScope = discoveryQosObj.discoveryScope;
		this.providerMustSupportOnChange = discoveryQosObj.providerMustSupportOnChange;
	}

	/**
	 * Parameterized constructor
	 *
	 * @param cacheMaxAge The maximum age of a cached entry in milliseconds
	 * @param discoveryTimeout Discovery TTL
	 * @param discoveryScope The discovery scope: at which level (GLOBAL/LOCAL) should providers be searched.
	 * @param providerMustSupportOnChange True, if the provider is required to support the OnChange publication
	 */
	public DiscoveryQos(
		Long cacheMaxAge,
		Long discoveryTimeout,
		DiscoveryScope discoveryScope,
		Boolean providerMustSupportOnChange
		) {
		this.cacheMaxAge = cacheMaxAge;
		this.discoveryTimeout = discoveryTimeout;
		this.discoveryScope = discoveryScope;
		this.providerMustSupportOnChange = providerMustSupportOnChange;
	}

	/**
	 * Gets CacheMaxAge
	 *
	 * @return The maximum age of a cached entry in milliseconds
	 */
	@JsonIgnore
	public Long getCacheMaxAge() {
		return cacheMaxAge;
	}

	/**
	 * Sets CacheMaxAge
	 *
	 * @param cacheMaxAge The maximum age of a cached entry in milliseconds
	 */
	@JsonIgnore
	public void setCacheMaxAge(Long cacheMaxAge) {
		if (cacheMaxAge == null) {
			throw new IllegalArgumentException("setting cacheMaxAge to null is not allowed");
		}
		this.cacheMaxAge = cacheMaxAge;
	}

	/**
	 * Gets DiscoveryTimeout
	 *
	 * @return Discovery TTL
	 */
	@JsonIgnore
	public Long getDiscoveryTimeout() {
		return discoveryTimeout;
	}

	/**
	 * Sets DiscoveryTimeout
	 *
	 * @param discoveryTimeout Discovery TTL
	 */
	@JsonIgnore
	public void setDiscoveryTimeout(Long discoveryTimeout) {
		if (discoveryTimeout == null) {
			throw new IllegalArgumentException("setting discoveryTimeout to null is not allowed");
		}
		this.discoveryTimeout = discoveryTimeout;
	}

	/**
	 * Gets DiscoveryScope
	 *
	 * @return The discovery scope: at which level (GLOBAL/LOCAL) should providers be searched.
	 */
	@JsonIgnore
	public DiscoveryScope getDiscoveryScope() {
		return discoveryScope;
	}

	/**
	 * Sets DiscoveryScope
	 *
	 * @param discoveryScope The discovery scope: at which level (GLOBAL/LOCAL) should providers be searched.
	 */
	@JsonIgnore
	public void setDiscoveryScope(DiscoveryScope discoveryScope) {
		if (discoveryScope == null) {
			throw new IllegalArgumentException("setting discoveryScope to null is not allowed");
		}
		this.discoveryScope = discoveryScope;
	}

	/**
	 * Gets ProviderMustSupportOnChange
	 *
	 * @return True, if the provider is required to support the OnChange publication
	 */
	@JsonIgnore
	public Boolean getProviderMustSupportOnChange() {
		return providerMustSupportOnChange;
	}

	/**
	 * Sets ProviderMustSupportOnChange
	 *
	 * @param providerMustSupportOnChange True, if the provider is required to support the OnChange publication
	 */
	@JsonIgnore
	public void setProviderMustSupportOnChange(Boolean providerMustSupportOnChange) {
		if (providerMustSupportOnChange == null) {
			throw new IllegalArgumentException("setting providerMustSupportOnChange to null is not allowed");
		}
		this.providerMustSupportOnChange = providerMustSupportOnChange;
	}


	/**
	 * Stringifies the class
	 *
	 * @return stringified class content
	 */
	@Override
	public String toString() {
		return "DiscoveryQos ["
		+ "cacheMaxAge=" + this.cacheMaxAge + ", "
		+ "discoveryTimeout=" + this.discoveryTimeout + ", "
		+ "discoveryScope=" + this.discoveryScope + ", "
		+ "providerMustSupportOnChange=" + this.providerMustSupportOnChange
		+ "]";
	}

	/**
	 * Check for equality
	 *
	 * @param obj Reference to the object to compare to
	 * @return true, if objects are equal, false otherwise
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		DiscoveryQos other = (DiscoveryQos) obj;
		if (this.cacheMaxAge == null) {
			if (other.cacheMaxAge != null) {
				return false;
			}
		} else if (!this.cacheMaxAge.equals(other.cacheMaxAge)){
			return false;
		}
		if (this.discoveryTimeout == null) {
			if (other.discoveryTimeout != null) {
				return false;
			}
		} else if (!this.discoveryTimeout.equals(other.discoveryTimeout)){
			return false;
		}
		if (this.discoveryScope == null) {
			if (other.discoveryScope != null) {
				return false;
			}
		} else if (!this.discoveryScope.equals(other.discoveryScope)){
			return false;
		}
		if (this.providerMustSupportOnChange == null) {
			if (other.providerMustSupportOnChange != null) {
				return false;
			}
		} else if (!this.providerMustSupportOnChange.equals(other.providerMustSupportOnChange)){
			return false;
		}
		return true;
	}

	/**
	 * Calculate code for hashing based on member contents
	 *
	 * @return The calculated hash code
	 */
	@Override
	public int hashCode() {
		int result = 1;
		final int prime = 31;
		result = prime * result + ((this.cacheMaxAge == null) ? 0 : this.cacheMaxAge.hashCode());
		result = prime * result + ((this.discoveryTimeout == null) ? 0 : this.discoveryTimeout.hashCode());
		result = prime * result + ((this.discoveryScope == null) ? 0 : this.discoveryScope.hashCode());
		result = prime * result + ((this.providerMustSupportOnChange == null) ? 0 : this.providerMustSupportOnChange.hashCode());
		return result;
	}
}

	
