		/*
		 *
		 * Copyright (C) 2011 - 2018 BMW Car IT GmbH
		 *
		 * Licensed under the Apache License, Version 2.0 (the "License");
		 * you may not use this file except in compliance with the License.
		 * You may obtain a copy of the License at
		 *
		 *      http://www.apache.org/licenses/LICENSE-2.0
		 *
		 * Unless required by applicable law or agreed to in writing, software
		 * distributed under the License is distributed on an "AS IS" BASIS,
		 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		 * See the License for the specific language governing permissions and
		 * limitations under the License.
		 */
		
		// #####################################################
		//#######################################################
		//###                                                 ###
		//##    WARNING: This file is generated. DO NOT EDIT   ##
		//##             All changes will be lost!             ##
		//###                                                 ###
		//#######################################################
		// #####################################################

package joynr.types;
import java.io.Serializable;

import io.joynr.subtypes.JoynrType;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;

// NOTE: serialVersionUID is not defined since we don't support Franca versions right now.
//       The compiler will generate a serialVersionUID based on the class and its members
//       (cf. http://docs.oracle.com/javase/6/docs/platform/serialization/spec/class.html#4100),
//       which is probably more restrictive than what we want.

/**
 * a version information
 */
@SuppressWarnings("serial")
public class Version implements Serializable, JoynrType {
	public static final int MAJOR_VERSION = 0;
	public static final int MINOR_VERSION = 0;
	@JsonProperty("majorVersion")
	private Integer majorVersion;
	@JsonProperty("minorVersion")
	private Integer minorVersion;

	/**
	 * Default Constructor
	 */
	public Version() {
		this.majorVersion = 0;
		this.minorVersion = 0;
	}

	/**
	 * Copy constructor
	 *
	 * @param versionObj reference to the object to be copied
	 */
	public Version(Version versionObj) {
		this.majorVersion = versionObj.majorVersion;
		this.minorVersion = versionObj.minorVersion;
	}

	/**
	 * Parameterized constructor
	 *
	 * @param majorVersion the major version id
	 * @param minorVersion the minor version id
	 */
	public Version(
		Integer majorVersion,
		Integer minorVersion
		) {
		this.majorVersion = majorVersion;
		this.minorVersion = minorVersion;
	}

	/**
	 * Gets MajorVersion
	 *
	 * @return the major version id
	 */
	@JsonIgnore
	public Integer getMajorVersion() {
		return majorVersion;
	}

	/**
	 * Sets MajorVersion
	 *
	 * @param majorVersion the major version id
	 */
	@JsonIgnore
	public void setMajorVersion(Integer majorVersion) {
		if (majorVersion == null) {
			throw new IllegalArgumentException("setting majorVersion to null is not allowed");
		}
		this.majorVersion = majorVersion;
	}

	/**
	 * Gets MinorVersion
	 *
	 * @return the minor version id
	 */
	@JsonIgnore
	public Integer getMinorVersion() {
		return minorVersion;
	}

	/**
	 * Sets MinorVersion
	 *
	 * @param minorVersion the minor version id
	 */
	@JsonIgnore
	public void setMinorVersion(Integer minorVersion) {
		if (minorVersion == null) {
			throw new IllegalArgumentException("setting minorVersion to null is not allowed");
		}
		this.minorVersion = minorVersion;
	}


	/**
	 * Stringifies the class
	 *
	 * @return stringified class content
	 */
	@Override
	public String toString() {
		return "Version ["
		+ "majorVersion=" + this.majorVersion + ", "
		+ "minorVersion=" + this.minorVersion
		+ "]";
	}

	/**
	 * Check for equality
	 *
	 * @param obj Reference to the object to compare to
	 * @return true, if objects are equal, false otherwise
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Version other = (Version) obj;
		if (this.majorVersion == null) {
			if (other.majorVersion != null) {
				return false;
			}
		} else if (!this.majorVersion.equals(other.majorVersion)){
			return false;
		}
		if (this.minorVersion == null) {
			if (other.minorVersion != null) {
				return false;
			}
		} else if (!this.minorVersion.equals(other.minorVersion)){
			return false;
		}
		return true;
	}

	/**
	 * Calculate code for hashing based on member contents
	 *
	 * @return The calculated hash code
	 */
	@Override
	public int hashCode() {
		int result = 1;
		final int prime = 31;
		result = prime * result + ((this.majorVersion == null) ? 0 : this.majorVersion.hashCode());
		result = prime * result + ((this.minorVersion == null) ? 0 : this.minorVersion.hashCode());
		return result;
	}
}

	
