/*
 * Decompiled with CFR 0.152.
 */
package joynr;

import io.joynr.pubsub.HeartbeatSubscriptionInformation;
import joynr.UnicastSubscriptionQos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicSubscriptionQos
extends UnicastSubscriptionQos
implements HeartbeatSubscriptionInformation {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(PeriodicSubscriptionQos.class);
    private static final long NO_ALERT_AFTER_INTERVAL = 0L;
    private static final long MIN_PERIOD_MS = 50L;
    private static final long MAX_PERIOD_MS = 2592000000L;
    private static final long DEFAULT_PERIOD_MS = 60000L;
    private static final long MAX_ALERT_AFTER_INTERVAL_MS = 2592000000L;
    private static final long DEFAULT_ALERT_AFTER_INTERVAL_MS = 0L;
    private long periodMs = 60000L;
    private long alertAfterIntervalMs = 0L;

    @Override
    public long getAlertAfterIntervalMs() {
        return this.alertAfterIntervalMs;
    }

    public PeriodicSubscriptionQos setAlertAfterIntervalMs(long alertAfterIntervalMs) {
        if (alertAfterIntervalMs > 2592000000L) {
            this.alertAfterIntervalMs = 2592000000L;
            logger.warn("AlertAfterInterval_ms > MAX_ALERT_AFTER_INTERVAL_MS. Using MAX_ALERT_AFTER_INTERVAL_MS: {}", (Object)2592000000L);
        } else {
            this.alertAfterIntervalMs = alertAfterIntervalMs;
        }
        if (this.alertAfterIntervalMs != 0L && this.alertAfterIntervalMs < this.periodMs) {
            this.alertAfterIntervalMs = this.periodMs;
            logger.warn("AlertAfterInterval_ms < MIN_ALERT_AFTER_INTERVAL and will therefore be set to the period: {}", (Object)this.periodMs);
        }
        return this;
    }

    public void clearAlertAfterInterval() {
        this.alertAfterIntervalMs = 0L;
    }

    @Override
    public long getPeriodMs() {
        return this.periodMs;
    }

    public PeriodicSubscriptionQos setPeriodMs(long periodMs) {
        if (periodMs < 50L) {
            this.periodMs = 50L;
            logger.warn("PeriodMs < MIN_PERIOD_MS. Using MIN_PERIOD_MS: {}", (Object)50L);
        } else if (periodMs > 2592000000L) {
            this.periodMs = 2592000000L;
            logger.warn("PeriodMs > MAX_PERIOD_MS. Using MAX_PERIOD_MS: {}", (Object)2592000000L);
        } else {
            this.periodMs = periodMs;
        }
        if (this.alertAfterIntervalMs != 0L && this.alertAfterIntervalMs < this.periodMs) {
            this.alertAfterIntervalMs = this.periodMs;
            logger.warn("AlertAfterIntervalMs < periodMs. Setting alertAfterIntervalMs = periodMs: {}", (Object)this.periodMs);
        }
        return this;
    }

    @Override
    public PeriodicSubscriptionQos setExpiryDateMs(long expiryDateMs) {
        return (PeriodicSubscriptionQos)super.setExpiryDateMs(expiryDateMs);
    }

    @Override
    public PeriodicSubscriptionQos setPublicationTtlMs(long publicationTtlMs) {
        return (PeriodicSubscriptionQos)super.setPublicationTtlMs(publicationTtlMs);
    }

    @Override
    public PeriodicSubscriptionQos setValidityMs(long validityMs) {
        return (PeriodicSubscriptionQos)super.setValidityMs(validityMs);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.alertAfterIntervalMs ^ this.alertAfterIntervalMs >>> 32);
        result = 31 * result + (int)(this.periodMs ^ this.periodMs >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PeriodicSubscriptionQos other = (PeriodicSubscriptionQos)obj;
        if (this.alertAfterIntervalMs != other.alertAfterIntervalMs) {
            return false;
        }
        return this.periodMs == other.periodMs;
    }
}

