/*
 * Decompiled with CFR 0.152.
 */
package joynr.exceptions;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.joynr.exceptions.JoynrException;
import java.io.IOException;
import joynr.exceptions.MethodInvocationException;

public class ApplicationException
extends Exception
implements JoynrException {
    private static final long serialVersionUID = 6620625652713563976L;
    private static final String JSON_FIELD_NAME_ERROR_ENUM = "name";
    private static final String JSON_FIELD_NAME_TYPE = "_typeName";
    @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="_typeName")
    @JsonSerialize(using=JoynrErrorEnumSerializer.class)
    @JsonDeserialize(using=JoynrErrorEnumDeSerializer.class)
    private Enum<?> error;

    protected ApplicationException() {
    }

    public ApplicationException(Enum<?> error) {
        this.error = error;
    }

    public ApplicationException(Enum<?> error, String message) {
        super(message);
        this.error = error;
    }

    public <T extends Enum<?>> T getError() {
        try {
            return (T)this.error;
        }
        catch (ClassCastException e) {
            throw new MethodInvocationException("cannot cast enum " + this.error);
        }
    }

    @Override
    public String toString() {
        return super.toString() + ": error: " + this.error;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationException other = (ApplicationException)obj;
        if (this.getMessage() == null ? other.getMessage() != null : !this.getMessage().equals(other.getMessage())) {
            return false;
        }
        return !(this.error == null ? other.error != null : !this.error.equals(other.error));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        result = 31 * result + (this.error == null ? 0 : this.error.hashCode());
        return result;
    }

    public static class JoynrErrorEnumDeSerializer
    extends StdDeserializer<Enum> {
        private static final long serialVersionUID = 1L;

        public JoynrErrorEnumDeSerializer() {
            super(Enum.class);
        }

        public Enum deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return null;
        }

        public Enum deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
            String typeName = null;
            String enumName = null;
            if (!jp.getCurrentToken().equals((Object)JsonToken.START_OBJECT)) {
                throw new IOException("Invalid Json format: parser does not point to START_OBJECT!");
            }
            if (!jp.getCurrentName().equals("error")) {
                throw new IOException("Invalid Json format: parser does not point to error enum");
            }
            while (!jp.getCurrentToken().equals((Object)JsonToken.END_OBJECT)) {
                jp.nextToken();
                if (!jp.getCurrentToken().equals((Object)JsonToken.FIELD_NAME)) continue;
                if (jp.getText().equals(ApplicationException.JSON_FIELD_NAME_TYPE)) {
                    jp.nextToken();
                    typeName = jp.getText();
                    continue;
                }
                if (!jp.getText().equals(ApplicationException.JSON_FIELD_NAME_ERROR_ENUM)) continue;
                jp.nextToken();
                enumName = jp.getText();
            }
            if (typeName == null) {
                throw new IOException("Invalid Json format: \"_typeName\" not found!");
            }
            if (enumName == null) {
                throw new IOException("Invalid Json format: enum \"name\" not found!");
            }
            try {
                return Enum.valueOf(Class.forName(typeName).asSubclass(Enum.class), enumName);
            }
            catch (ClassNotFoundException e) {
                try {
                    int indexOfLastDot = typeName.lastIndexOf(".");
                    typeName = new StringBuilder(typeName).replace(indexOfLastDot, indexOfLastDot + 1, "$").toString();
                    return Enum.valueOf(Class.forName(typeName).asSubclass(Enum.class), enumName);
                }
                catch (ClassNotFoundException e2) {
                    throw new IOException(e2);
                }
            }
        }
    }

    public static class JoynrErrorEnumSerializer
    extends StdSerializer<Enum> {
        private static final long serialVersionUID = 1L;

        public JoynrErrorEnumSerializer() {
            super(Enum.class);
        }

        public void serialize(Enum value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            provider.defaultSerializeValue((Object)value, jgen);
        }

        public void serializeWithType(Enum value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
            typeSer.writeCustomTypePrefixForObject((Object)value, jgen, value.getClass().getName().replace("$", "."));
            jgen.writeFieldName(ApplicationException.JSON_FIELD_NAME_ERROR_ENUM);
            jgen.writeString(value.name());
            typeSer.writeTypeSuffixForObject((Object)value, jgen);
        }
    }
}

