/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.util;

import io.joynr.JoynrVersion;
import io.joynr.util.AnnotationUtil;
import joynr.types.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionUtil {
    private static final Logger logger = LoggerFactory.getLogger(VersionUtil.class);

    public static Version getVersionFromAnnotation(Class<?> annotatedClass) {
        JoynrVersion versionAnnotation = AnnotationUtil.getAnnotation(annotatedClass, JoynrVersion.class);
        if (versionAnnotation == null) {
            throw new IllegalStateException("No @JoynrVersion found on " + annotatedClass);
        }
        Version version = new Version(versionAnnotation.major(), versionAnnotation.minor());
        logger.trace("Created version {} for interface class {}", (Object)version, annotatedClass);
        return version;
    }
}

