/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.provider;

import io.joynr.exceptions.JoynrException;
import io.joynr.provider.PromiseListener;
import java.util.Arrays;
import java.util.Optional;

public class PromiseKeeper
implements PromiseListener {
    private State state = State.PENDING;
    private Object[] values = null;
    private JoynrException error = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFulfillment(Object ... values) {
        PromiseKeeper promiseKeeper = this;
        synchronized (promiseKeeper) {
            this.values = values;
            this.state = State.FULFILLED;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRejection(JoynrException error) {
        PromiseKeeper promiseKeeper = this;
        synchronized (promiseKeeper) {
            this.error = error;
            this.state = State.REJECTED;
            this.notifyAll();
        }
    }

    public Optional<Object[]> getValues() throws InterruptedException {
        return this.getValues(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Object[]> getValues(long timeout) throws InterruptedException {
        if (!this.isSettled()) {
            PromiseKeeper promiseKeeper = this;
            synchronized (promiseKeeper) {
                this.wait(timeout);
            }
        }
        if (this.values == null) {
            return Optional.ofNullable(null);
        }
        return Optional.of(Arrays.copyOf(this.values, this.values.length));
    }

    public Optional<JoynrException> getError() throws InterruptedException {
        return this.getError(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<JoynrException> getError(long timeout) throws InterruptedException {
        if (!this.isSettled()) {
            PromiseKeeper promiseKeeper = this;
            synchronized (promiseKeeper) {
                this.wait(timeout);
            }
        }
        return Optional.ofNullable(this.error);
    }

    public void waitForSettlement() throws InterruptedException {
        this.waitForSettlement(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSettlement(long timeout) throws InterruptedException {
        if (!this.isSettled()) {
            PromiseKeeper promiseKeeper = this;
            synchronized (promiseKeeper) {
                this.wait(timeout);
            }
        }
    }

    public boolean isFulfilled() {
        return this.state == State.FULFILLED;
    }

    public boolean isRejected() {
        return this.state == State.REJECTED;
    }

    public boolean isSettled() {
        return this.isFulfilled() || this.isRejected();
    }

    private static enum State {
        PENDING,
        FULFILLED,
        REJECTED;

    }
}

