/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.context;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoynrMessageScope
implements Scope {
    private static final Logger logger = LoggerFactory.getLogger(JoynrMessageScope.class);
    private ThreadLocal<Map<Key<?>, Object>> entries = new ThreadLocal();

    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
        logger.trace("Called with {} and {}", key, unscoped);
        return new Provider<T>(){

            public T get() {
                Map<Key<?>, Object> scopeObject = JoynrMessageScope.this.entries.get();
                if (scopeObject == null) {
                    throw new IllegalStateException("Scope " + JoynrMessageScope.class.getSimpleName() + " not active.");
                }
                logger.trace("Get called on scoped provider for {}", (Object)key);
                Object result = scopeObject.get(key);
                if (result == null) {
                    result = unscoped.get();
                    scopeObject.put(key, result);
                }
                logger.trace("Returning instance {} for key {}", result, (Object)key);
                return result;
            }
        };
    }

    public void activate() {
        if (this.entries.get() != null) {
            throw new IllegalStateException("Scope " + JoynrMessageScope.class.getSimpleName() + " is already active.");
        }
        logger.trace("Activating {} scope", (Object)JoynrMessageScope.class.getSimpleName());
        this.entries.set(new HashMap());
    }

    public void deactivate() {
        if (this.entries.get() == null) {
            throw new IllegalStateException("Scope " + JoynrMessageScope.class.getSimpleName() + " is not currently active. Can't deactivate.");
        }
        logger.trace("Deactivating {} scope", (Object)JoynrMessageScope.class.getSimpleName());
        this.entries.remove();
    }
}

