/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.exceptions;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.joynr.exceptions.JoynrRuntimeException;
import java.text.SimpleDateFormat;

public class JoynrTimeoutException
extends JoynrRuntimeException {
    private static final long serialVersionUID = 1L;
    @JsonProperty
    private long expiryDate;

    protected JoynrTimeoutException() {
    }

    public JoynrTimeoutException(long expiryDate) {
        super("ttl expired on: " + new SimpleDateFormat("dd/MM HH:mm:ss:sss").format(expiryDate));
        this.expiryDate = expiryDate;
    }

    public JoynrTimeoutException(long expiryDate, String requestReplyId) {
        super("ttl for request with requestReplyId " + requestReplyId + " expired on: " + new SimpleDateFormat("dd/MM HH:mm:ss:sss").format(expiryDate));
        this.expiryDate = expiryDate;
    }

    public long getExpiryDate() {
        return this.expiryDate;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.expiryDate ^ this.expiryDate >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JoynrTimeoutException other = (JoynrTimeoutException)obj;
        return this.expiryDate == other.expiryDate;
    }
}

