/*
 * Decompiled with CFR 0.152.
 */
package joynr;

import io.joynr.pubsub.HeartbeatSubscriptionInformation;
import joynr.OnChangeSubscriptionQos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnChangeWithKeepAliveSubscriptionQos
extends OnChangeSubscriptionQos
implements HeartbeatSubscriptionInformation {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(OnChangeWithKeepAliveSubscriptionQos.class);
    private static final long MIN_MAX_INTERVAL_MS = 50L;
    private static final long MAX_MAX_INTERVAL_MS = 2592000000L;
    private static final long DEFAULT_MAX_INTERVAL_MS = 60000L;
    private static final long NO_ALERT_AFTER_INTERVAL = 0L;
    private static final long MAX_ALERT_AFTER_INTERVAL_MS = 2592000000L;
    private long maxIntervalMs = 60000L;
    private long alertAfterIntervalMs = 0L;

    public long getMaxIntervalMs() {
        return this.maxIntervalMs;
    }

    @Override
    public long getPeriodMs() {
        return this.getMaxIntervalMs();
    }

    public OnChangeWithKeepAliveSubscriptionQos setMaxIntervalMs(long maxIntervalMs) {
        if (maxIntervalMs < 50L) {
            this.maxIntervalMs = 50L;
            logger.warn("MaxIntervalMs < MIN_MAX_INTERVAL_MS. Using MIN_MAX_INTERVAL_MS: {}", (Object)50L);
        } else if (maxIntervalMs > 2592000000L) {
            this.maxIntervalMs = 2592000000L;
            logger.warn("MaxIntervalMs > MAX_MAX_INTERVAL_MS. Using MAX_MAX_INTERVAL_MS: {}", (Object)2592000000L);
        } else {
            this.maxIntervalMs = maxIntervalMs;
        }
        if (this.maxIntervalMs < this.getMinIntervalMs()) {
            this.maxIntervalMs = this.getMinIntervalMs();
        }
        if (this.alertAfterIntervalMs != 0L && this.alertAfterIntervalMs < this.maxIntervalMs) {
            this.alertAfterIntervalMs = this.maxIntervalMs;
            logger.warn("AlertAfterIntervalMs < maxIntervalMs. Setting alertAfterIntervalMs = maxIntervalMs: {}", (Object)this.maxIntervalMs);
        }
        return this;
    }

    @Override
    public long getAlertAfterIntervalMs() {
        return this.alertAfterIntervalMs;
    }

    public OnChangeWithKeepAliveSubscriptionQos setAlertAfterIntervalMs(long alertAfterIntervalMs) {
        if (alertAfterIntervalMs > 2592000000L) {
            this.alertAfterIntervalMs = 2592000000L;
            logger.warn("AlertAfterIntervalMs > maxInterval. Using MAX_ALERT_AFTER_INTERVAL_MS: {}", (Object)2592000000L);
        } else {
            this.alertAfterIntervalMs = alertAfterIntervalMs;
        }
        if (this.alertAfterIntervalMs != 0L && this.alertAfterIntervalMs < this.maxIntervalMs) {
            this.alertAfterIntervalMs = this.maxIntervalMs;
            logger.warn("Attempt to set alertAfterIntervalMs to a value smaller than maxInterval; setting to maxInterval instead");
        }
        return this;
    }

    @Override
    public OnChangeWithKeepAliveSubscriptionQos setExpiryDateMs(long expiryDateMs) {
        return (OnChangeWithKeepAliveSubscriptionQos)super.setExpiryDateMs(expiryDateMs);
    }

    @Override
    public OnChangeWithKeepAliveSubscriptionQos setMinIntervalMs(long minIntervalMs) {
        super.setMinIntervalMs(minIntervalMs);
        return this.setMaxIntervalMs(this.maxIntervalMs);
    }

    @Override
    public OnChangeWithKeepAliveSubscriptionQos setPublicationTtlMs(long publicationTtlMs) {
        return (OnChangeWithKeepAliveSubscriptionQos)super.setPublicationTtlMs(publicationTtlMs);
    }

    @Override
    public OnChangeWithKeepAliveSubscriptionQos setValidityMs(long validityMs) {
        return (OnChangeWithKeepAliveSubscriptionQos)super.setValidityMs(validityMs);
    }

    public void clearAlertAfterInterval() {
        this.alertAfterIntervalMs = 0L;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.alertAfterIntervalMs ^ this.alertAfterIntervalMs >>> 32);
        result = 31 * result + (int)(this.maxIntervalMs ^ this.maxIntervalMs >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OnChangeWithKeepAliveSubscriptionQos other = (OnChangeWithKeepAliveSubscriptionQos)obj;
        if (this.alertAfterIntervalMs != other.alertAfterIntervalMs) {
            return false;
        }
        return this.maxIntervalMs == other.maxIntervalMs;
    }
}

