/*
 * Decompiled with CFR 0.152.
 */
package joynr.system.RoutingTypes;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.inject.Inject;
import io.joynr.exceptions.JoynrSerializationException;
import io.joynr.util.ObjectMapper;
import java.io.IOException;
import joynr.system.RoutingTypes.Address;

public class RoutingTypesUtil {
    @Inject
    private static ObjectMapper objectMapper;

    public static String toAddressString(Address address) {
        try {
            return objectMapper.writeValueAsString(address);
        }
        catch (JsonProcessingException e) {
            throw new JoynrSerializationException("unable to serialize address: " + address + " reason:" + e.getMessage());
        }
    }

    public static Address fromAddressString(String addressString) {
        try {
            return objectMapper.readValue(addressString, Address.class);
        }
        catch (IOException e) {
            throw new JoynrSerializationException("unable to deserialize address: " + addressString + " reason:" + e.getMessage());
        }
    }
}

