/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.context;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import io.joynr.context.JoynrMessageScope;
import io.joynr.context.JoynrMessageScopeModule;
import io.joynr.context.JoynrMessageScoped;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoynrMessageScopeTest {
    private static final Logger logger = LoggerFactory.getLogger(JoynrMessageScopeTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetScopedInstance() {
        Injector injector = this.setupInjectorWithScope(new Module[0]);
        JoynrMessageScope scope = (JoynrMessageScope)injector.getInstance(JoynrMessageScope.class);
        scope.activate();
        try {
            ScopedInstance instance = (ScopedInstance)injector.getInstance(ScopedInstance.class);
            logger.debug("On first getInstance got: {}", (Object)instance);
            Assert.assertNotNull((Object)instance);
            Assert.assertNull((Object)instance.getValue());
            instance.setValue("myValue");
            ScopedInstance secondInstance = (ScopedInstance)injector.getInstance(ScopedInstance.class);
            logger.debug("On second getInstance got: {}", (Object)secondInstance);
            Assert.assertNotNull((Object)secondInstance);
            Assert.assertEquals((Object)"myValue", (Object)secondInstance.getValue());
        }
        finally {
            scope.deactivate();
        }
        try {
            injector.getInstance(ScopedInstance.class);
            Assert.fail((String)"Should not be able to get scoped bean from inactive scope.");
        }
        catch (ProvisionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalStateException));
        }
    }

    private Injector setupInjectorWithScope(Module ... modules) {
        Injector injector = Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                this.install((Module)new JoynrMessageScopeModule());
            }
        }});
        return injector;
    }

    @JoynrMessageScoped
    private static class ScopedInstance {
        private String value;

        private ScopedInstance() {
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

