/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging;

import io.joynr.messaging.MessagingQos;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MessagingQosCustomHeadersTest {
    private Boolean conforms;
    private String key;
    private String value;

    public MessagingQosCustomHeadersTest(String key, String value, Boolean conforms) {
        this.key = key;
        this.value = value;
        this.conforms = conforms;
    }

    @Parameterized.Parameters(name="{index}: {0}:{1}")
    public static Collection<Object[]> data() {
        return Arrays.asList({new String("key"), new String("value"), true}, {new String("1key"), new String("1value"), true}, {new String("key1"), new String("value1"), true}, {new String("key-1"), new String("value1"), true}, {new String("123"), new String("123"), true}, {new String("key"), new String("one two"), true}, {new String("key"), new String("one;two"), true}, {new String("key"), new String("one:two"), true}, {new String("key"), new String("one,two"), true}, {new String("key"), new String("one+two"), true}, {new String("key"), new String("one&two"), true}, {new String("key"), new String("one?two"), true}, {new String("key"), new String("one-two"), true}, {new String("key"), new String("one.two"), true}, {new String("key"), new String("one*two"), true}, {new String("key"), new String("one/two"), true}, {new String("key"), new String("one\\two"), true}, {new String("key"), new String("one_two"), true}, {new String("key"), new String("wrongvalue\u00a7"), false}, {new String("key"), new String("wrongvalue$"), false}, {new String("key"), new String("wrongvalue%"), false}, {new String("key"), new String("wrongval\u00fc"), false}, {new String("wrongkey "), new String("value"), false}, {new String("wrongkey;"), new String("value"), false}, {new String("wrongkey:"), new String("value"), false}, {new String("wrongkey,"), new String("value"), false}, {new String("wrongkey+"), new String("value"), false}, {new String("wrongkey&"), new String("value"), false}, {new String("wrongkey?"), new String("value"), false}, {new String("wrongkey."), new String("value"), false}, {new String("wrongkey*"), new String("value"), false}, {new String("wrongkey/"), new String("value"), false}, {new String("wrongkey\\"), new String("value"), false});
    }

    @Test
    public void putCustomMessageHeaderTest() {
        MessagingQos messagingQos = new MessagingQos();
        try {
            messagingQos.putCustomMessageHeader(this.key, this.value);
            if (!this.conforms.booleanValue()) {
                Assert.fail((String)("key: " + this.key + " value: " + this.value + " should have caused an exception"));
            }
            Map customMessageHeaders = messagingQos.getCustomMessageHeaders();
            Assert.assertTrue((boolean)customMessageHeaders.containsKey(this.key));
            Assert.assertEquals((Object)this.value, customMessageHeaders.get(this.key));
        }
        catch (Exception e) {
            if (this.conforms.booleanValue()) {
                Assert.fail((String)("key: " + this.key + " value: " + this.value + " should not have caused an exception"));
            }
            return;
        }
    }

    @Test
    public void putCustomMessageHeadersTest() {
        MessagingQos messagingQos = new MessagingQos();
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        customHeaders.put(this.key, this.value);
        try {
            messagingQos.putAllCustomMessageHeaders(customHeaders);
            if (!this.conforms.booleanValue()) {
                Assert.fail((String)("key: " + this.key + " value: " + this.value + " should have caused an exception"));
            }
            Map customMessageHeaders = messagingQos.getCustomMessageHeaders();
            Assert.assertTrue((boolean)customMessageHeaders.containsKey(this.key));
            Assert.assertEquals((Object)this.value, customMessageHeaders.get(this.key));
        }
        catch (Exception e) {
            if (this.conforms.booleanValue()) {
                Assert.fail((String)("key: " + this.key + " value: " + this.value + " should not have caused an exception"));
            }
            return;
        }
    }
}

