/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging;

import io.joynr.messaging.MessagingQos;
import io.joynr.messaging.MessagingQosEffort;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class MessagingQosTest {
    @Test
    public void testDefaultEffort() {
        MessagingQos messagingQos = new MessagingQos(0L);
        Assert.assertEquals((Object)MessagingQosEffort.NORMAL, (Object)messagingQos.getEffort());
    }

    @Test
    public void testCustomEffort() {
        MessagingQos messagingQos = new MessagingQos(0L, MessagingQosEffort.BEST_EFFORT);
        Assert.assertEquals((Object)MessagingQosEffort.BEST_EFFORT, (Object)messagingQos.getEffort());
    }

    @Test
    public void testEffortSetter() {
        MessagingQos messagingQos = new MessagingQos(0L);
        Assert.assertEquals((Object)MessagingQosEffort.NORMAL, (Object)messagingQos.getEffort());
        messagingQos.setEffort(MessagingQosEffort.BEST_EFFORT);
        Assert.assertEquals((Object)MessagingQosEffort.BEST_EFFORT, (Object)messagingQos.getEffort());
    }

    @Test
    public void testDefaultEncrypt() {
        MessagingQos messagingQos = new MessagingQos(0L);
        Assert.assertEquals((Object)false, (Object)messagingQos.getEncrypt());
    }

    @Test
    public void testCustomEncrypt() {
        boolean encrypt = true;
        MessagingQos messagingQos = new MessagingQos(0L, MessagingQosEffort.BEST_EFFORT, encrypt);
        Assert.assertEquals((Object)encrypt, (Object)messagingQos.getEncrypt());
        messagingQos = new MessagingQos(0L, encrypt);
        Assert.assertEquals((Object)encrypt, (Object)messagingQos.getEncrypt());
    }

    @Test
    public void testEncryptSetter() {
        MessagingQos messagingQos = new MessagingQos(0L);
        Assert.assertEquals((Object)false, (Object)messagingQos.getEncrypt());
        boolean encrypt = true;
        messagingQos.setEncrypt(encrypt);
        Assert.assertEquals((Object)encrypt, (Object)messagingQos.getEncrypt());
    }

    @Test
    public void testDefaultCompress() {
        MessagingQos messagingQos = new MessagingQos(0L);
        Assert.assertEquals((Object)false, (Object)messagingQos.getCompress());
    }

    @Test
    public void testCompressSetter() {
        MessagingQos messagingQos = new MessagingQos(0L);
        Assert.assertEquals((Object)false, (Object)messagingQos.getCompress());
        boolean compress = true;
        messagingQos.setCompress(compress);
        Assert.assertEquals((Object)compress, (Object)messagingQos.getCompress());
    }

    @Test
    public void testCustomHeaderConstructor() {
        long ttl = 12345L;
        boolean compress = true;
        MessagingQosEffort effort = MessagingQosEffort.BEST_EFFORT;
        HashMap<String, String> customHeaders = new HashMap<String, String>();
        customHeaders.put("key1", "value1");
        customHeaders.put("key2", "value2");
        MessagingQos messagingQos = new MessagingQos(12345L, effort, customHeaders, true);
        Assert.assertEquals((long)12345L, (long)messagingQos.getRoundTripTtl_ms());
        Assert.assertEquals((Object)effort, (Object)messagingQos.getEffort());
        Assert.assertEquals(customHeaders, (Object)messagingQos.getCustomMessageHeaders());
        Assert.assertEquals((Object)true, (Object)messagingQos.getCompress());
    }

    @Test
    public void testToString() {
        MessagingQos messagingQos = new MessagingQos(0L);
        boolean compress = true;
        messagingQos.setCompress(compress);
        boolean encrypt = true;
        messagingQos.setEncrypt(encrypt);
        messagingQos.setTtl_ms(1000L);
        messagingQos.setEffort(MessagingQosEffort.BEST_EFFORT);
        messagingQos.putCustomMessageHeader("key1", "value1");
        messagingQos.putCustomMessageHeader("key2", "value2");
        String expectedToStringResult = "MessagingQos [compress=true, customHeaders=" + messagingQos.getCustomMessageHeaders().toString() + ", effort=BEST_EFFORT, encrypt=true, ttl_ms=1000]";
        Assert.assertEquals((Object)expectedToStringResult, (Object)messagingQos.toString());
    }
}

