/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.provider;

import io.joynr.provider.AbstractDeferred;
import io.joynr.provider.DeferredVoid;
import io.joynr.provider.Promise;
import io.joynr.provider.PromiseListener;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DeferredVoidTest {
    @Test
    public void promiseStateIsCorrectOnFulfillment() {
        DeferredVoid deferred = new DeferredVoid();
        Promise promise = new Promise((AbstractDeferred)deferred);
        Assert.assertFalse((boolean)promise.isSettled());
        Assert.assertFalse((boolean)promise.isRejected());
        Assert.assertFalse((boolean)promise.isFulfilled());
        deferred.resolve();
        Assert.assertTrue((boolean)promise.isSettled());
        Assert.assertFalse((boolean)promise.isRejected());
        Assert.assertTrue((boolean)promise.isFulfilled());
    }

    @Test
    public void promiseNotifiesListenersOnFulfillment() {
        DeferredVoid deferred = new DeferredVoid();
        Promise promise = new Promise((AbstractDeferred)deferred);
        PromiseListener listener = (PromiseListener)Mockito.mock(PromiseListener.class);
        promise.then(listener);
        Assert.assertFalse((boolean)promise.isSettled());
        deferred.resolve();
        Assert.assertTrue((boolean)promise.isFulfilled());
        ((PromiseListener)Mockito.verify((Object)listener)).onFulfillment(new Object[0]);
    }

    @Test
    public void fulfilledPromiseNotifiesListener() {
        DeferredVoid deferred = new DeferredVoid();
        Promise promise = new Promise((AbstractDeferred)deferred);
        PromiseListener listener = (PromiseListener)Mockito.mock(PromiseListener.class);
        deferred.resolve();
        Assert.assertTrue((boolean)promise.isFulfilled());
        promise.then(listener);
        ((PromiseListener)Mockito.verify((Object)listener)).onFulfillment(new Object[0]);
    }
}

