/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.provider;

import io.joynr.exceptions.JoynrException;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.provider.AbstractDeferred;
import io.joynr.provider.Promise;
import io.joynr.provider.PromiseKeeper;
import io.joynr.provider.PromiseListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import joynr.tests.testProvider;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PromiseKeeperTest {
    static ExecutorService executer = Executors.newSingleThreadExecutor();

    @Test
    public void keeperStateIsCorrectOnRejection() {
        AbstractDeferred deferred = new AbstractDeferred(){};
        Promise promise = new Promise(deferred);
        PromiseKeeper keeper = new PromiseKeeper();
        promise.then((PromiseListener)keeper);
        Assert.assertFalse((boolean)keeper.isSettled());
        Assert.assertFalse((boolean)keeper.isRejected());
        Assert.assertFalse((boolean)keeper.isFulfilled());
        deferred.reject((JoynrException)new JoynrRuntimeException());
        Assert.assertTrue((boolean)keeper.isSettled());
        Assert.assertTrue((boolean)keeper.isRejected());
        Assert.assertFalse((boolean)keeper.isFulfilled());
    }

    @Test
    public void keeperStateIsCorrectOnFulfillment() {
        testProvider.MethodWithNoInputParametersDeferred deferred = new testProvider.MethodWithNoInputParametersDeferred();
        Promise promise = new Promise((AbstractDeferred)deferred);
        PromiseKeeper keeper = new PromiseKeeper();
        promise.then((PromiseListener)keeper);
        Assert.assertFalse((boolean)keeper.isSettled());
        Assert.assertFalse((boolean)keeper.isRejected());
        Assert.assertFalse((boolean)keeper.isFulfilled());
        deferred.resolve(42);
        Assert.assertTrue((boolean)keeper.isSettled());
        Assert.assertFalse((boolean)keeper.isRejected());
        Assert.assertTrue((boolean)keeper.isFulfilled());
    }

    @Test
    public void unsettledKeeperTimesOut() throws InterruptedException {
        AbstractDeferred deferred = new AbstractDeferred(){};
        Promise promise = new Promise(deferred);
        PromiseKeeper keeper = new PromiseKeeper();
        promise.then((PromiseListener)keeper);
        Assert.assertFalse((boolean)keeper.getError(10L).isPresent());
        Assert.assertFalse((boolean)keeper.getValues(10L).isPresent());
    }

    @Test
    public void getErrorWaitsForRejection() throws InterruptedException {
        final AbstractDeferred deferred = new AbstractDeferred(){};
        Promise promise = new Promise(deferred);
        PromiseKeeper keeper = new PromiseKeeper();
        final JoynrRuntimeException expectedError = new JoynrRuntimeException("test exception");
        promise.then((PromiseListener)keeper);
        executer.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                deferred.reject((JoynrException)expectedError);
            }
        });
        JoynrException error = (JoynrException)keeper.getError().get();
        Assert.assertEquals((Object)expectedError, (Object)error);
    }

    @Test
    public void getValuesWaitsForFulfillment() throws InterruptedException {
        final testProvider.MethodWithNoInputParametersDeferred deferred = new testProvider.MethodWithNoInputParametersDeferred();
        Promise promise = new Promise((AbstractDeferred)deferred);
        PromiseKeeper keeper = new PromiseKeeper();
        final Integer expectedValue = 42;
        promise.then((PromiseListener)keeper);
        executer.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                deferred.resolve(expectedValue);
            }
        });
        Object[] values = (Object[])keeper.getValues().get();
        Assert.assertArrayEquals((Object[])new Object[]{expectedValue}, (Object[])values);
    }

    @Test
    public void waitForSettlementBlocks() throws InterruptedException {
        final AbstractDeferred deferredToResolve = new AbstractDeferred(){};
        Promise promiseToResolve = new Promise(deferredToResolve);
        PromiseKeeper keeperToResolve = new PromiseKeeper();
        promiseToResolve.then((PromiseListener)keeperToResolve);
        executer.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                deferredToResolve.resolve(new Object[0]);
            }
        });
        keeperToResolve.waitForSettlement();
        Assert.assertTrue((boolean)keeperToResolve.isSettled());
        final AbstractDeferred deferredToReject = new AbstractDeferred(){};
        Promise promiseToReject = new Promise(deferredToReject);
        PromiseKeeper keeperToReject = new PromiseKeeper();
        promiseToReject.then((PromiseListener)keeperToReject);
        executer.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                deferredToReject.reject(null);
            }
        });
        keeperToReject.waitForSettlement();
        Assert.assertTrue((boolean)keeperToReject.isSettled());
    }
}

