/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.provider;

import io.joynr.exceptions.JoynrException;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.provider.AbstractDeferred;
import io.joynr.provider.Promise;
import io.joynr.provider.PromiseListener;
import joynr.tests.testProvider;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PromiseTest {
    @Test
    public void promiseStateIsCorrectOnRejection() {
        AbstractDeferred deferred = new AbstractDeferred(){};
        Promise promise = new Promise(deferred);
        Assert.assertFalse((boolean)promise.isSettled());
        Assert.assertFalse((boolean)promise.isRejected());
        Assert.assertFalse((boolean)promise.isFulfilled());
        deferred.reject((JoynrException)new JoynrRuntimeException());
        Assert.assertTrue((boolean)promise.isSettled());
        Assert.assertTrue((boolean)promise.isRejected());
        Assert.assertFalse((boolean)promise.isFulfilled());
    }

    @Test
    public void promiseStateIsCorrectOnFulfillment() {
        testProvider.MethodWithNoInputParametersDeferred deferred = new testProvider.MethodWithNoInputParametersDeferred();
        Promise promise = new Promise((AbstractDeferred)deferred);
        Assert.assertFalse((boolean)promise.isSettled());
        Assert.assertFalse((boolean)promise.isRejected());
        Assert.assertFalse((boolean)promise.isFulfilled());
        deferred.resolve(42);
        Assert.assertTrue((boolean)promise.isSettled());
        Assert.assertFalse((boolean)promise.isRejected());
        Assert.assertTrue((boolean)promise.isFulfilled());
    }

    @Test
    public void addingNullListenerDoesNotThrow() {
        AbstractDeferred deferred = new AbstractDeferred(){};
        Promise promise = new Promise(deferred);
        promise.then(null);
        deferred.reject((JoynrException)new JoynrRuntimeException("test exception"));
    }

    @Test
    public void promiseNotifiesListenersOnRejection() {
        AbstractDeferred deferred = new AbstractDeferred(){};
        Promise promise = new Promise(deferred);
        PromiseListener listener = (PromiseListener)Mockito.mock(PromiseListener.class);
        JoynrRuntimeException expectedError = new JoynrRuntimeException("test exception");
        promise.then(listener);
        Assert.assertFalse((boolean)promise.isSettled());
        deferred.reject((JoynrException)expectedError);
        Assert.assertTrue((boolean)promise.isRejected());
        ((PromiseListener)Mockito.verify((Object)listener)).onRejection((JoynrException)expectedError);
    }

    @Test
    public void rejectedPromiseNotifiesListener() {
        AbstractDeferred deferred = new AbstractDeferred(){};
        Promise promise = new Promise(deferred);
        PromiseListener listener = (PromiseListener)Mockito.mock(PromiseListener.class);
        JoynrRuntimeException expectedError = new JoynrRuntimeException("test exception");
        deferred.reject((JoynrException)expectedError);
        Assert.assertTrue((boolean)promise.isRejected());
        promise.then(listener);
        ((PromiseListener)Mockito.verify((Object)listener)).onRejection((JoynrException)expectedError);
    }

    @Test
    public void promiseNotifiesListenersOnFulfillment() {
        testProvider.MethodWithNoInputParametersDeferred deferred = new testProvider.MethodWithNoInputParametersDeferred();
        Promise promise = new Promise((AbstractDeferred)deferred);
        PromiseListener listener = (PromiseListener)Mockito.mock(PromiseListener.class);
        Integer expectedValue = 42;
        promise.then(listener);
        Assert.assertFalse((boolean)promise.isSettled());
        deferred.resolve(expectedValue);
        Assert.assertTrue((boolean)promise.isFulfilled());
        ((PromiseListener)Mockito.verify((Object)listener)).onFulfillment(new Object[]{expectedValue});
    }

    @Test
    public void fulfilledPromiseNotifiesListener() {
        testProvider.MethodWithNoInputParametersDeferred deferred = new testProvider.MethodWithNoInputParametersDeferred();
        Promise promise = new Promise((AbstractDeferred)deferred);
        PromiseListener listener = (PromiseListener)Mockito.mock(PromiseListener.class);
        Integer expectedValue = 42;
        deferred.resolve(expectedValue);
        Assert.assertTrue((boolean)promise.isFulfilled());
        promise.then(listener);
        ((PromiseListener)Mockito.verify((Object)listener)).onFulfillment(new Object[]{expectedValue});
    }
}

