/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.provider;

import io.joynr.provider.JoynrInterface;
import io.joynr.provider.JoynrProvider;
import io.joynr.provider.SubscriptionPublisherFactory;
import joynr.test.NonInstantiable;
import joynr.tests.DefaulttestProvider;
import joynr.tests.testProvider;
import joynr.tests.testSubscriptionPublisher;
import joynr.tests.testSubscriptionPublisherImpl;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SubscriptionPublisherFactoryTest {
    SubscriptionPublisherFactory subscriptionPublisherFactory;

    @Before
    public void setUp() throws Exception {
        this.subscriptionPublisherFactory = new SubscriptionPublisherFactory();
    }

    @Test
    public void testCreateWithCorrectProvider() throws Exception {
        DefaulttestProvider providerSpy = (DefaulttestProvider)Mockito.spy((Object)new DefaulttestProvider());
        this.subscriptionPublisherFactory.create((Object)providerSpy);
        ((DefaulttestProvider)Mockito.verify((Object)providerSpy, (VerificationMode)Mockito.times((int)1))).setSubscriptionPublisher((testSubscriptionPublisher)Mockito.any(testSubscriptionPublisherImpl.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateWithWrongProvider() throws Exception {
        JoynrProvider providerSpy = (JoynrProvider)Mockito.mock(JoynrProvider.class);
        this.subscriptionPublisherFactory.create((Object)providerSpy);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateWithMissingSubscriptionPublisher() throws Exception {
        testProviderWithoutSubscriptionPublisher providerSpy = (testProviderWithoutSubscriptionPublisher)Mockito.mock(testProviderWithoutSubscriptionPublisher.class);
        this.subscriptionPublisherFactory.create((Object)providerSpy);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateWithNonInstantiableSubscriptionPublisher() throws Exception {
        testProviderWithNonInstantiableSubscriptionPublisher providerSpy = (testProviderWithNonInstantiableSubscriptionPublisher)Mockito.mock(testProviderWithNonInstantiableSubscriptionPublisher.class);
        this.subscriptionPublisherFactory.create((Object)providerSpy);
    }

    @JoynrInterface(name="test/NonInstantiable", provider=testProvider.class, provides=NonInstantiable.class)
    private static interface testProviderWithNonInstantiableSubscriptionPublisher {
    }

    @JoynrInterface(name="test/WithoutSubscriptionPublisher", provider=testProvider.class, provides=testProvider.class)
    private static interface testProviderWithoutSubscriptionPublisher {
    }
}

