/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.util;

import io.joynr.JoynrVersion;
import io.joynr.dispatcher.rpc.annotation.StatelessCallbackCorrelation;
import io.joynr.provider.JoynrInterface;
import io.joynr.provider.ProviderAnnotations;
import io.joynr.proxy.ReplyContext;
import io.joynr.util.AnnotationUtil;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.inject.Qualifier;
import joynr.tests.DefaulttestProvider;
import joynr.tests.test;
import joynr.tests.testProvider;
import joynr.tests.testStatelessAsyncCallback;
import joynr.tests.testTypes.TestEnum;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AnnotationUtilTest {
    @Test
    public void testgetAnnotationsRecursive() {
        Collection annotations = AnnotationUtil.getAnnotationsRecursive(DefaulttestProvider.class);
        Collection joynrInterfaceAnnotations = annotations.stream().filter(JoynrInterface.class::isInstance).collect(Collectors.toList());
        Assert.assertThat((Object)joynrInterfaceAnnotations, (Matcher)IsCollectionWithSize.hasSize((int)1));
        Annotation interfaceNameAnnotation = (Annotation)joynrInterfaceAnnotations.iterator().next();
        Assert.assertThat((Object)interfaceNameAnnotation, (Matcher)Matchers.instanceOf(JoynrInterface.class));
        Assert.assertThat((Object)((JoynrInterface)interfaceNameAnnotation).name(), (Matcher)Matchers.equalTo((Object)"tests/test"));
    }

    @Test
    public void testInterfaceNameAnnotation() {
        JoynrInterface joynrInterfaceAnnotations = (JoynrInterface)AnnotationUtil.getAnnotation(DefaulttestProvider.class, JoynrInterface.class);
        Assert.assertThat((Object)joynrInterfaceAnnotations.name(), (Matcher)Matchers.equalTo((Object)"tests/test"));
    }

    @Test
    public void testInterfaceClassAnnotation() {
        JoynrInterface interfaceClassAnnotation = (JoynrInterface)AnnotationUtil.getAnnotation(DefaulttestProvider.class, JoynrInterface.class);
        Assert.assertEquals((Object)interfaceClassAnnotation.provider(), testProvider.class);
        Assert.assertEquals((Object)interfaceClassAnnotation.provides(), test.class);
    }

    @Test
    public void testMajorVersionAnnotation() {
        JoynrVersion joynrVersionnAnnotation = (JoynrVersion)AnnotationUtil.getAnnotation(DefaulttestProvider.class, JoynrVersion.class);
        Assert.assertThat((Object)joynrVersionnAnnotation.major(), (Matcher)Matchers.equalTo((Object)47));
    }

    @Test
    public void testMinorVersionAnnotation() {
        JoynrVersion joynrVersionnAnnotation = (JoynrVersion)AnnotationUtil.getAnnotation(DefaulttestProvider.class, JoynrVersion.class);
        Assert.assertThat((Object)joynrVersionnAnnotation.minor(), (Matcher)Matchers.equalTo((Object)11));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getExceptionForProviderInstanceWithouthAnnotation() {
        ProviderAnnotations.getInterfaceName((Object)"");
    }

    @Test
    public void getAnnotationInProxyObject() {
        Object fixture = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{testProvider.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return null;
            }
        });
        Assert.assertThat((Object)ProviderAnnotations.getInterfaceName((Object)fixture), (Matcher)Matchers.equalTo((Object)"tests/test"));
    }

    @Test
    public void testGetAnnotationFromMethodRecursively() throws Exception {
        StatelessCallbackCorrelation result = (StatelessCallbackCorrelation)AnnotationUtil.getAnnotation((Method)this.getMethodWithAnnotation(), StatelessCallbackCorrelation.class);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetDirectAnnotationForMethod() throws Exception {
        DirectAnnotation result = (DirectAnnotation)AnnotationUtil.getAnnotation((Method)this.getMethodWithAnnotation(), DirectAnnotation.class);
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetAnnotationForMethodReturnsNullForNonExistentAnnotation() throws Exception {
        Qualifier result = (Qualifier)AnnotationUtil.getAnnotation((Method)this.getMethodWithAnnotation(), Qualifier.class);
        Assert.assertNull((Object)result);
    }

    @Test
    public void testGetAnnotationFromSuperclassMethod() throws Exception {
        Method method = MyChildClass.class.getMethod("getEnumAttributeSuccess", TestEnum.class, ReplyContext.class);
        DirectAnnotation result = (DirectAnnotation)AnnotationUtil.getAnnotation((Method)method, DirectAnnotation.class);
        Assert.assertNotNull((Object)result);
    }

    private Method getMethodWithAnnotation() throws NoSuchMethodException {
        return MyTestStatelessAsyncCallback.class.getMethod("getEnumAttributeSuccess", TestEnum.class, ReplyContext.class);
    }

    class MyChildClass
    extends MyTestStatelessAsyncCallback {
        MyChildClass() {
        }

        @Override
        public void getEnumAttributeSuccess(TestEnum enumAttribute, ReplyContext replyContext) {
        }
    }

    class MyTestStatelessAsyncCallback
    implements testStatelessAsyncCallback {
        MyTestStatelessAsyncCallback() {
        }

        @Override
        @DirectAnnotation
        public void getEnumAttributeSuccess(TestEnum enumAttribute, ReplyContext replyContext) {
        }

        public String getUseCase() {
            return "attribute test";
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    static @interface DirectAnnotation {
    }
}

