/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.util;

import io.joynr.util.MultiMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MultiMapTest {
    @Test
    public void storesMultipleValuesPerKey() {
        MultiMap multiMap = new MultiMap();
        String key1 = "key1";
        String key2 = "key2";
        HashSet<String> keySet = new HashSet<String>(Arrays.asList("key1", "key2"));
        HashSet<String> values1 = new HashSet<String>(Arrays.asList("values1_1", "values1_2, values1_3"));
        HashSet<String> values2 = new HashSet<String>(Arrays.asList("values2_1", "values2_2, values2_3"));
        values1.forEach(v -> multiMap.put((Object)"key1", v));
        values2.forEach(v -> multiMap.put((Object)"key2", v));
        Assert.assertEquals(values1, (Object)multiMap.get((Object)"key1"));
        Assert.assertEquals(values2, (Object)multiMap.get((Object)"key2"));
        Assert.assertEquals(keySet, (Object)multiMap.keySet());
    }

    @Test
    public void containsKeyAfterPut() {
        MultiMap multiMap = new MultiMap();
        String key = "key";
        String value = "value";
        multiMap.put((Object)"key", (Object)"value");
        Assert.assertTrue((boolean)multiMap.containsKey((Object)"key"));
    }

    @Test
    public void emptyMapDoesNotContainKey() {
        MultiMap multiMap = new MultiMap();
        String key = "key";
        Assert.assertFalse((boolean)multiMap.containsKey((Object)"key"));
    }

    @Test
    public void emptyMapIsEmpty() {
        MultiMap multiMap = new MultiMap();
        Assert.assertTrue((boolean)multiMap.isEmpty());
    }

    @Test
    public void mapIsNotEmptyAfterPut() {
        MultiMap multiMap = new MultiMap();
        multiMap.put((Object)"key", (Object)"value");
        Assert.assertFalse((boolean)multiMap.isEmpty());
    }

    @Test
    public void emptyMapKeySetIsEmpty() {
        MultiMap multiMap = new MultiMap();
        Assert.assertTrue((boolean)multiMap.keySet().isEmpty());
    }

    @Test
    public void getForNonExisitingKeyReturnsEmptySet() {
        MultiMap multiMap = new MultiMap();
        String key = "key";
        Set values = multiMap.get((Object)"key");
        Assert.assertTrue((boolean)values.isEmpty());
    }

    @Test
    public void getAndRemoveAllForNonExisitingKeyReturnsEmptySet() {
        MultiMap multiMap = new MultiMap();
        String key = "key";
        String value = "value";
        String nonExistedKey = "nonExistedKey";
        multiMap.put((Object)"key", (Object)"value");
        Assert.assertEquals((long)1L, (long)multiMap.size());
        Set values = multiMap.getAndRemoveAll((Object)"nonExistedKey");
        Assert.assertTrue((boolean)values.isEmpty());
        Assert.assertEquals((long)1L, (long)multiMap.size());
    }

    @Test
    public void getAndRemoveAllForExisitingKeyReturnsSetThenRemoveItFromTheBaseMap() {
        MultiMap multiMap = new MultiMap();
        String key = "key";
        String value1 = "value1";
        String value2 = "value2";
        String value3 = "value3";
        multiMap.put((Object)"key", (Object)"value1");
        multiMap.put((Object)"key", (Object)"value2");
        multiMap.put((Object)"key", (Object)"value3");
        Assert.assertTrue((boolean)multiMap.containsKey((Object)"key"));
        Assert.assertEquals((long)3L, (long)multiMap.size());
        Set values = multiMap.getAndRemoveAll((Object)"key");
        Assert.assertEquals((long)3L, (long)values.size());
        Assert.assertEquals((long)0L, (long)multiMap.size());
    }

    @Test
    public void removeNonExistingKeyValuePairReturnsFalse() {
        MultiMap multiMap = new MultiMap();
        String key = "key";
        String value1 = "value1";
        String value2 = "value2";
        Assert.assertFalse((boolean)multiMap.remove((Object)"key", (Object)"value1"));
        multiMap.put((Object)"key", (Object)"value1");
        Assert.assertFalse((boolean)multiMap.remove((Object)"key", (Object)"value2"));
    }

    @Test
    public void removeExistingKeyValuePairReturnsTrue() {
        MultiMap multiMap = new MultiMap();
        String key = "key";
        String value = "value";
        multiMap.put((Object)"key", (Object)"value");
        Assert.assertTrue((boolean)multiMap.remove((Object)"key", (Object)"value"));
    }

    @Test
    public void doesNotContainKeyAfterRemove() {
        MultiMap multiMap = new MultiMap();
        String key = "key";
        String value = "value";
        multiMap.put((Object)"key", (Object)"value");
        multiMap.remove((Object)"key", (Object)"value");
        Assert.assertFalse((boolean)multiMap.containsKey((Object)"key"));
    }

    @Test
    public void stillContainsKeyAfterPartialRemove() {
        MultiMap multiMap = new MultiMap();
        String key = "key";
        String value1 = "value_1";
        String value2 = "value_2";
        multiMap.put((Object)"key", (Object)"value_1");
        multiMap.put((Object)"key", (Object)"value_2");
        multiMap.remove((Object)"key", (Object)"value_1");
        Assert.assertTrue((boolean)multiMap.containsKey((Object)"key"));
    }

    @Test
    public void doesNotContainKeyAfterRemoveAll() {
        MultiMap multiMap = new MultiMap();
        String key = "key";
        HashSet<String> values = new HashSet<String>(Arrays.asList("value1", "value2, value3"));
        values.forEach(v -> multiMap.put((Object)"key", v));
        multiMap.removeAll((Object)"key");
        Assert.assertFalse((boolean)multiMap.containsKey((Object)"key"));
    }

    @Test
    public void emptyMapHasSizeZero() {
        MultiMap multiMap = new MultiMap();
        Assert.assertEquals((long)0L, (long)multiMap.size());
    }

    @Test
    public void mapSizeGrowsAndShrinks() {
        MultiMap multiMap = new MultiMap();
        String key = "key";
        HashSet<String> values = new HashSet<String>(Arrays.asList("value1", "value2, value3"));
        int size = 0;
        for (String v : values) {
            multiMap.put((Object)"key", (Object)v);
            Assert.assertEquals((long)(++size), (long)multiMap.size());
        }
        for (String v : values) {
            multiMap.remove((Object)"key", (Object)v);
            Assert.assertEquals((long)(--size), (long)multiMap.size());
        }
    }
}

