/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.util;

import io.joynr.util.ObjectMapper;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class ObjectMapperTest {
    @Mock
    com.fasterxml.jackson.databind.ObjectMapper realObjectMapper;

    @Test
    public void registerSubtypes_NewEntries() {
        ObjectMapper objectMapper = new ObjectMapper(this.realObjectMapper);
        objectMapper.registerSubtypes(new Class[]{A.class, B.class});
        ((com.fasterxml.jackson.databind.ObjectMapper)Mockito.verify((Object)this.realObjectMapper)).registerSubtypes(new Class[]{(Class)ArgumentMatchers.eq(A.class), (Class)ArgumentMatchers.eq(B.class)});
        objectMapper.registerSubtypes(new Class[]{C.class});
        ((com.fasterxml.jackson.databind.ObjectMapper)Mockito.verify((Object)this.realObjectMapper)).registerSubtypes(new Class[]{(Class)ArgumentMatchers.eq(C.class)});
        ((com.fasterxml.jackson.databind.ObjectMapper)Mockito.verify((Object)this.realObjectMapper, (VerificationMode)Mockito.times((int)2))).registerSubtypes(new Class[]{(Class)ArgumentMatchers.any()});
    }

    @Test
    public void registerSubtypes_NewAndExisitingEntries() {
        ObjectMapper objectMapper = new ObjectMapper(this.realObjectMapper);
        objectMapper.registerSubtypes(new Class[]{A.class, B.class});
        ((com.fasterxml.jackson.databind.ObjectMapper)Mockito.verify((Object)this.realObjectMapper)).registerSubtypes(new Class[]{(Class)ArgumentMatchers.eq(A.class), (Class)ArgumentMatchers.eq(B.class)});
        objectMapper.registerSubtypes(new Class[]{A.class, C.class});
        ((com.fasterxml.jackson.databind.ObjectMapper)Mockito.verify((Object)this.realObjectMapper)).registerSubtypes(new Class[]{(Class)ArgumentMatchers.eq(C.class)});
        ((com.fasterxml.jackson.databind.ObjectMapper)Mockito.verify((Object)this.realObjectMapper, (VerificationMode)Mockito.times((int)2))).registerSubtypes(new Class[]{(Class)ArgumentMatchers.any()});
    }

    @Test
    public void registerSubtypes_OmitCallForExisitingEntries() {
        ObjectMapper objectMapper = new ObjectMapper(this.realObjectMapper);
        objectMapper.registerSubtypes(new Class[]{A.class, B.class});
        objectMapper.registerSubtypes(new Class[]{A.class, B.class});
        ((com.fasterxml.jackson.databind.ObjectMapper)Mockito.verify((Object)this.realObjectMapper)).registerSubtypes(new Class[]{(Class)ArgumentMatchers.eq(A.class), (Class)ArgumentMatchers.eq(B.class)});
        ((com.fasterxml.jackson.databind.ObjectMapper)Mockito.verify((Object)this.realObjectMapper, (VerificationMode)Mockito.times((int)1))).registerSubtypes(new Class[]{(Class)ArgumentMatchers.any()});
    }

    private class C {
        private C() {
        }
    }

    private class B {
        private B() {
        }
    }

    private class A {
        private A() {
        }
    }
}

