/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.util;

import io.joynr.dispatcher.rpc.RequestStatus;
import io.joynr.util.ReflectionUtils;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class ReflectionUtilsTest {
    private void addSingleElementToFixture(Map<String, Class<?>[]> fixture, String expectedDatatypeName, Class<?> datatype) {
        fixture.put(expectedDatatypeName, new Class[]{datatype});
    }

    @Test
    public void testToDatatypeNames() {
        HashMap<String, Class<?>[]> fixture = new HashMap<String, Class<?>[]>();
        this.addSingleElementToFixture(fixture, "Boolean", Boolean.class);
        this.addSingleElementToFixture(fixture, "Boolean[]", Boolean[].class);
        this.addSingleElementToFixture(fixture, "Byte", Byte.class);
        this.addSingleElementToFixture(fixture, "Byte[]", Byte[].class);
        this.addSingleElementToFixture(fixture, "Short", Short.class);
        this.addSingleElementToFixture(fixture, "Short[]", Short[].class);
        this.addSingleElementToFixture(fixture, "Integer", Integer.class);
        this.addSingleElementToFixture(fixture, "Integer[]", Integer[].class);
        this.addSingleElementToFixture(fixture, "Long", Long.class);
        this.addSingleElementToFixture(fixture, "Long[]", Long[].class);
        this.addSingleElementToFixture(fixture, "Float", Float.class);
        this.addSingleElementToFixture(fixture, "Float[]", Float[].class);
        this.addSingleElementToFixture(fixture, "Double", Double.class);
        this.addSingleElementToFixture(fixture, "Double[]", Double[].class);
        this.addSingleElementToFixture(fixture, "String", String.class);
        this.addSingleElementToFixture(fixture, "String[]", String[].class);
        this.addSingleElementToFixture(fixture, "io.joynr.dispatcher.rpc.RequestStatus", RequestStatus.class);
        this.addSingleElementToFixture(fixture, "io.joynr.dispatcher.rpc.RequestStatus[]", RequestStatus[].class);
        for (Map.Entry entry : fixture.entrySet()) {
            String datatypeName = ReflectionUtils.toDatatypeNames((Class[])((Class[])entry.getValue()))[0];
            String key = (String)entry.getKey();
            Assert.assertEquals((Object)key, (Object)datatypeName);
        }
    }

    @Test
    public void testGetStaticMethodFromSuperInterfacesWithClassContainingSearchedMethod() throws NoSuchMethodException {
        Assert.assertNotNull((Object)ReflectionUtils.getStaticMethodFromSuperInterfaces(TestClassContainingSearchedMethod.class, (String)"oneMethodToRuleThemAll"));
    }

    @Test(expected=NoSuchMethodException.class)
    public void testGetStaticMethodFromSuperInterfacesWithClassNotContainingSearchedMethod() throws NoSuchMethodException {
        ReflectionUtils.getStaticMethodFromSuperInterfaces(TestClassNotContainingSearchedMethod.class, (String)"oneMethodToRuleThemAll");
    }

    @Test
    public void testGetStaticMethodFromSuperInterfacesWithParentClassContainingSearchedMethod() throws NoSuchMethodException {
        Assert.assertNotNull((Object)ReflectionUtils.getStaticMethodFromSuperInterfaces(TestClassWithParentContainingSearchedMethod.class, (String)"oneMethodToRuleThemAll"));
    }

    @Test(expected=NoSuchMethodException.class)
    public void testGetStaticMethodFromSuperInterfacesWithParentClassNotContainingSearchedMethod() throws NoSuchMethodException {
        ReflectionUtils.getStaticMethodFromSuperInterfaces(TestClassWithParentNotContainingSearchedMethod.class, (String)"oneMethodToRuleThemAll");
    }

    @Test
    public void testGetStaticMethodFromSuperInterfacesWithInterfaceContainingSearchedMethod() throws NoSuchMethodException {
        ReflectionUtils.getStaticMethodFromSuperInterfaces(TestInterfaceContainingSearchedMethod.class, (String)"oneMethodToRuleThemAll");
    }

    @Test(expected=NoSuchMethodException.class)
    public void testGetStaticMethodFromSuperInterfacesWithInterfaceNotContainingSearchedMethod() throws NoSuchMethodException {
        ReflectionUtils.getStaticMethodFromSuperInterfaces(TestInterfaceNotContainingSearchedMethod.class, (String)"oneMethodToRuleThemAll");
    }

    @Test
    public void testGetStaticMethodFromSuperInterfacesWithInterfaceExtendingInterfaceContainingSearchedMethod() throws NoSuchMethodException {
        ReflectionUtils.getStaticMethodFromSuperInterfaces(TestInterfaceExtendingInterfaceContainingSearchedMethod.class, (String)"oneMethodToRuleThemAll");
    }

    @Test(expected=NoSuchMethodException.class)
    public void testGetStaticMethodFromSuperInterfacesWithInterfaceExtendingInterfaceNotContainingSearchedMethod() throws NoSuchMethodException {
        ReflectionUtils.getStaticMethodFromSuperInterfaces(TestInterfaceExtendingInterfaceNotContainingSearchedMethod.class, (String)"oneMethodToRuleThemAll");
    }

    private static interface TestInterfaceExtendingInterfaceNotContainingSearchedMethod
    extends TestInterfaceNotContainingSearchedMethod {
    }

    private static interface TestInterfaceExtendingInterfaceContainingSearchedMethod
    extends TestInterfaceContainingSearchedMethod {
    }

    private static interface TestInterfaceNotContainingSearchedMethod {
    }

    private static interface TestInterfaceContainingSearchedMethod {
        public static void oneMethodToRuleThemAll() {
        }
    }

    private class ParentClassNotContainingSearchedMethod {
        private ParentClassNotContainingSearchedMethod() {
        }
    }

    private class ParentClassContainingSearchedMethod {
        private ParentClassContainingSearchedMethod() {
        }

        public void oneMethodToRuleThemAll() {
        }
    }

    private class TestClassWithParentNotContainingSearchedMethod
    extends ParentClassNotContainingSearchedMethod {
        private TestClassWithParentNotContainingSearchedMethod() {
        }
    }

    private class TestClassNotContainingSearchedMethod {
        private TestClassNotContainingSearchedMethod() {
        }
    }

    private class TestClassWithParentContainingSearchedMethod
    extends ParentClassContainingSearchedMethod {
        private TestClassWithParentContainingSearchedMethod() {
        }
    }

    private class TestClassContainingSearchedMethod {
        private TestClassContainingSearchedMethod() {
        }

        public void oneMethodToRuleThemAll() {
        }
    }
}

