/*
 * Decompiled with CFR 0.152.
 */
package joynr;

import joynr.OnChangeSubscriptionQos;
import joynr.OnChangeWithKeepAliveSubscriptionQos;
import joynr.PeriodicSubscriptionQos;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SubscriptionQosTest {
    @Before
    public void setUp() {
    }

    @Test
    public void createOnChangeSubscriptionQos() throws Exception {
        long expiryDateMs = System.currentTimeMillis() + 100000L;
        long publicationTtlMs = 2000L;
        long minIntervalMs = 100L;
        OnChangeSubscriptionQos onChangeSubscriptionQos = new OnChangeSubscriptionQos().setExpiryDateMs(expiryDateMs).setPublicationTtlMs(publicationTtlMs).setMinIntervalMs(minIntervalMs);
        Assert.assertEquals((long)expiryDateMs, (long)onChangeSubscriptionQos.getExpiryDateMs());
        Assert.assertEquals((long)publicationTtlMs, (long)onChangeSubscriptionQos.getPublicationTtlMs());
        Assert.assertEquals((long)minIntervalMs, (long)onChangeSubscriptionQos.getMinIntervalMs());
    }

    @Test
    public void createOnChangeSubscriptionQosWithValidity() throws Exception {
        long validityMs = 100000L;
        long lowerBound = System.currentTimeMillis() + validityMs;
        OnChangeSubscriptionQos onChangeSubscriptionQos = new OnChangeSubscriptionQos().setValidityMs(validityMs);
        long upperBound = System.currentTimeMillis() + validityMs;
        Assert.assertTrue((onChangeSubscriptionQos.getExpiryDateMs() >= lowerBound ? 1 : 0) != 0);
        Assert.assertTrue((onChangeSubscriptionQos.getExpiryDateMs() <= upperBound ? 1 : 0) != 0);
    }

    @Test
    public void createPeriodicSubscriptionQos() throws Exception {
        long expiryDateMs = System.currentTimeMillis() + 100000L;
        long publicationTtlMs = 2000L;
        long periodMs = 800L;
        long alertAfterIntervalMs = 3000L;
        PeriodicSubscriptionQos periodicSubscriptionQos = new PeriodicSubscriptionQos().setExpiryDateMs(expiryDateMs).setPublicationTtlMs(publicationTtlMs).setPeriodMs(periodMs).setAlertAfterIntervalMs(alertAfterIntervalMs);
        Assert.assertEquals((long)expiryDateMs, (long)periodicSubscriptionQos.getExpiryDateMs());
        Assert.assertEquals((long)publicationTtlMs, (long)periodicSubscriptionQos.getPublicationTtlMs());
        Assert.assertEquals((long)periodMs, (long)periodicSubscriptionQos.getPeriodMs());
        Assert.assertEquals((long)alertAfterIntervalMs, (long)periodicSubscriptionQos.getAlertAfterIntervalMs());
    }

    @Test
    public void createPeriodicSubscriptionQosWithValidity() throws Exception {
        long validityMs = 1000L;
        long lowerBound = System.currentTimeMillis() + validityMs;
        PeriodicSubscriptionQos periodicSubscriptionQos = new PeriodicSubscriptionQos().setValidityMs(validityMs);
        long upperBound = System.currentTimeMillis() + validityMs;
        Assert.assertTrue((periodicSubscriptionQos.getExpiryDateMs() >= lowerBound ? 1 : 0) != 0);
        Assert.assertTrue((periodicSubscriptionQos.getExpiryDateMs() <= upperBound ? 1 : 0) != 0);
    }

    @Test
    public void createOnChangeWithKeepAliveSubscriptionQos() throws Exception {
        long expiryDateMs = System.currentTimeMillis() + 100000L;
        long publicationTtlMs = 2000L;
        long alertAfterIntervalMs = 4000L;
        long maxIntervalMs = 3000L;
        long minIntervalMs = 100L;
        OnChangeWithKeepAliveSubscriptionQos onChangeWithKeepAliveSubscriptionQos = new OnChangeWithKeepAliveSubscriptionQos().setExpiryDateMs(expiryDateMs).setPublicationTtlMs(publicationTtlMs).setMaxIntervalMs(maxIntervalMs).setMinIntervalMs(minIntervalMs).setAlertAfterIntervalMs(alertAfterIntervalMs);
        Assert.assertEquals((long)expiryDateMs, (long)onChangeWithKeepAliveSubscriptionQos.getExpiryDateMs());
        Assert.assertEquals((long)publicationTtlMs, (long)onChangeWithKeepAliveSubscriptionQos.getPublicationTtlMs());
        Assert.assertEquals((long)maxIntervalMs, (long)onChangeWithKeepAliveSubscriptionQos.getMaxIntervalMs());
        Assert.assertEquals((long)minIntervalMs, (long)onChangeWithKeepAliveSubscriptionQos.getMinIntervalMs());
        Assert.assertEquals((long)alertAfterIntervalMs, (long)onChangeWithKeepAliveSubscriptionQos.getAlertAfterIntervalMs());
    }

    @Test
    public void alertAfterIntervalAdjustedIfSmallerThanPeriod() throws Exception {
        long periodMs = 5000L;
        long alertAfterIntervalMs = 1000L;
        PeriodicSubscriptionQos periodicSubscriptionQos = new PeriodicSubscriptionQos().setPeriodMs(periodMs).setAlertAfterIntervalMs(alertAfterIntervalMs);
        Assert.assertEquals((long)periodMs, (long)periodicSubscriptionQos.getPeriodMs());
        Assert.assertEquals((long)periodMs, (long)periodicSubscriptionQos.getAlertAfterIntervalMs());
    }

    @Test
    public void alertAfterIntervalAdjustedIfSmallerThanMaxInterval() throws Exception {
        long alertAfterIntervalMs = 4000L;
        long maxIntervalMs = 5000L;
        OnChangeWithKeepAliveSubscriptionQos onChangeWithKeepAliveSubscriptionQos = new OnChangeWithKeepAliveSubscriptionQos().setMaxIntervalMs(maxIntervalMs).setAlertAfterIntervalMs(alertAfterIntervalMs);
        Assert.assertEquals((long)maxIntervalMs, (long)onChangeWithKeepAliveSubscriptionQos.getMaxIntervalMs());
        Assert.assertEquals((long)maxIntervalMs, (long)onChangeWithKeepAliveSubscriptionQos.getAlertAfterIntervalMs());
    }

    @Test
    public void maxIntervalAdjustedIfSmallerThanMinInterval() throws Exception {
        long minIntervalMs = 2000L;
        long maxIntervalMs = 1000L;
        OnChangeWithKeepAliveSubscriptionQos onChangeWithKeepAliveSubscriptionQos = new OnChangeWithKeepAliveSubscriptionQos().setMaxIntervalMs(maxIntervalMs).setMinIntervalMs(minIntervalMs);
        Assert.assertEquals((long)minIntervalMs, (long)onChangeWithKeepAliveSubscriptionQos.getMinIntervalMs());
        Assert.assertEquals((long)minIntervalMs, (long)onChangeWithKeepAliveSubscriptionQos.getMaxIntervalMs());
    }
}

