/*
 * Decompiled with CFR 0.152.
 */
package joynr.system.RoutingTypes;

import io.joynr.util.JoynrUtil;
import io.joynr.util.ObjectMapper;
import java.lang.reflect.Field;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.MqttAddress;
import joynr.system.RoutingTypes.RoutingTypesUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RoutingTypesUtilTest {
    String mqttAddressString = "{\"_typeName\":\"joynr.system.RoutingTypes.MqttAddress\",\"brokerUri\":\"tcp://host:1234\",\"topic\":\"topic\"}";
    static final String BROKERURI = "tcp://host:1234";
    static final String TOPIC = "topic";
    static final String CHANNELID = JoynrUtil.createUuidString();

    @Before
    public void setUp() throws Exception {
        Field objectMapperField = RoutingTypesUtil.class.getDeclaredField("objectMapper");
        objectMapperField.setAccessible(true);
        objectMapperField.set(RoutingTypesUtil.class, new ObjectMapper());
    }

    @Test
    public void toMqttAddressStringTest() {
        MqttAddress mqttAddress = new MqttAddress(BROKERURI, TOPIC);
        String addressString = RoutingTypesUtil.toAddressString((Address)mqttAddress);
        Assert.assertEquals((Object)this.mqttAddressString, (Object)addressString);
    }

    @Test
    public void fromMqttAddressString() {
        Address address = RoutingTypesUtil.fromAddressString((String)this.mqttAddressString);
        Assert.assertTrue((boolean)(address instanceof MqttAddress));
        MqttAddress mqttAddress = (MqttAddress)address;
        Assert.assertEquals((Object)BROKERURI, (Object)mqttAddress.getBrokerUri());
        Assert.assertEquals((Object)TOPIC, (Object)mqttAddress.getTopic());
    }
}

