/*
 * Decompiled with CFR 0.152.
 */
package joynr.test;

import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;

public class JoynrTestLoggingRule
extends ExternalResource {
    private Logger logger;
    private String separator;
    private String beforeString;
    private String afterString;

    public JoynrTestLoggingRule(Logger logger) {
        this.logger = logger;
        this.separator = "[--------]";
        this.beforeString = "";
        this.afterString = "";
    }

    protected void before() throws Throwable {
        this.logger.info(this.separator);
        this.logger.info(this.beforeString);
        this.logger.info(this.separator);
    }

    protected void after() {
        this.logger.info(this.separator);
        this.logger.info(this.afterString);
        this.logger.info(this.separator);
    }

    public Statement apply(Statement statement, Description description) {
        String testName = description.getClassName() + "." + description.getMethodName();
        this.beforeString = "[RUN TEST] " + testName;
        this.afterString = "[END TEST] " + testName;
        return super.apply(statement, description);
    }
}

