/*
 * Decompiled with CFR 0.152.
 */
package joynr.vehicle;

import io.joynr.provider.AbstractJoynrProvider;
import io.joynr.pubsub.publication.BroadcastFilterImpl;
import java.util.HashSet;
import java.util.Set;
import joynr.types.Localisation.GpsLocation;
import joynr.types.Localisation.Trip;
import joynr.vehicle.NavigationProvider;
import joynr.vehicle.NavigationSubscriptionPublisher;

public abstract class NavigationAbstractProvider
extends AbstractJoynrProvider
implements NavigationProvider {
    private Set<BroadcastFilterImpl> queuedBroadcastFilters = new HashSet<BroadcastFilterImpl>();
    protected NavigationSubscriptionPublisher navigationSubscriptionPublisher;

    public void setSubscriptionPublisher(NavigationSubscriptionPublisher navigationSubscriptionPublisher) {
        this.navigationSubscriptionPublisher = navigationSubscriptionPublisher;
        for (BroadcastFilterImpl filter : this.queuedBroadcastFilters) {
            this.navigationSubscriptionPublisher.addBroadcastFilter(filter);
        }
        this.queuedBroadcastFilters.clear();
    }

    public void addBroadcastFilter(BroadcastFilterImpl filter) {
        if (this.navigationSubscriptionPublisher != null) {
            this.navigationSubscriptionPublisher.addBroadcastFilter(filter);
        } else {
            this.queuedBroadcastFilters.add(filter);
        }
    }

    public void addBroadcastFilter(BroadcastFilterImpl ... filters) {
        if (this.navigationSubscriptionPublisher != null) {
            this.navigationSubscriptionPublisher.addBroadcastFilter(filters);
        } else {
            for (BroadcastFilterImpl filter : filters) {
                this.queuedBroadcastFilters.add(filter);
            }
        }
    }

    public void guidanceActiveChanged(Boolean guidanceActive) {
        if (this.navigationSubscriptionPublisher != null) {
            this.navigationSubscriptionPublisher.guidanceActiveChanged(guidanceActive);
        }
    }

    public void guidedTripChanged(Trip guidedTrip) {
        if (this.navigationSubscriptionPublisher != null) {
            this.navigationSubscriptionPublisher.guidedTripChanged(guidedTrip);
        }
    }

    public void tripsChanged(Trip[] trips) {
        if (this.navigationSubscriptionPublisher != null) {
            this.navigationSubscriptionPublisher.tripsChanged(trips);
        }
    }

    public void fireLocationUpdateSelective(GpsLocation location) {
        if (this.navigationSubscriptionPublisher != null) {
            this.navigationSubscriptionPublisher.fireLocationUpdateSelective(location);
        }
    }

    public void fireLocationUpdateWithSpeedSelective(GpsLocation location, Float currentSpeed) {
        if (this.navigationSubscriptionPublisher != null) {
            this.navigationSubscriptionPublisher.fireLocationUpdateWithSpeedSelective(location, currentSpeed);
        }
    }

    public void fireLocationUpdate(GpsLocation location, String ... partitions) {
        if (this.navigationSubscriptionPublisher != null) {
            this.navigationSubscriptionPublisher.fireLocationUpdate(location, partitions);
        }
    }

    public void fireLocationUpdateWithSpeed(GpsLocation location, Float currentSpeed, String ... partitions) {
        if (this.navigationSubscriptionPublisher != null) {
            this.navigationSubscriptionPublisher.fireLocationUpdateWithSpeed(location, currentSpeed, partitions);
        }
    }
}

