/*
 *
 * Copyright (C) 2011 - 2018 BMW Car IT GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// #####################################################
//#######################################################
//###                                                 ###
//##    WARNING: This file is generated. DO NOT EDIT   ##
//##             All changes will be lost!             ##
//###                                                 ###
//#######################################################
// #####################################################
package joynr.infrastructure;

import io.joynr.provider.Promise;
import io.joynr.provider.AbstractDeferred;

import io.joynr.provider.JoynrInterface;
import io.joynr.JoynrVersion;

import joynr.infrastructure.DacTypes.MasterAccessControlEntry;
import joynr.infrastructure.DacTypes.MasterRegistrationControlEntry;
import joynr.infrastructure.DacTypes.OwnerAccessControlEntry;
import joynr.infrastructure.DacTypes.OwnerRegistrationControlEntry;

@JoynrInterface(provides = AccessControlListEditor.class, provider = AccessControlListEditorProvider.class, name = "infrastructure/AccessControlListEditor")
@JoynrVersion(major = 0, minor = 1)
public interface AccessControlListEditorProvider {


	/**
	 * updateMasterAccessControlEntry
	 * @param updatedMasterAce the parameter updatedMasterAce
	 * @return promise for asynchronous handling
	 */
	public Promise<UpdateMasterAccessControlEntryDeferred> updateMasterAccessControlEntry(
			MasterAccessControlEntry updatedMasterAce
	);

	/**
	 * removeMasterAccessControlEntry
	 * @param uid the parameter uid
	 * @param domain the parameter domain
	 * @param interfaceName the parameter interfaceName
	 * @param operation the parameter operation
	 * @return promise for asynchronous handling
	 */
	public Promise<RemoveMasterAccessControlEntryDeferred> removeMasterAccessControlEntry(
			String uid,
			String domain,
			String interfaceName,
			String operation
	);

	/**
	 * updateMediatorAccessControlEntry
	 * @param updatedMediatorAce the parameter updatedMediatorAce
	 * @return promise for asynchronous handling
	 */
	public Promise<UpdateMediatorAccessControlEntryDeferred> updateMediatorAccessControlEntry(
			MasterAccessControlEntry updatedMediatorAce
	);

	/**
	 * removeMediatorAccessControlEntry
	 * @param uid the parameter uid
	 * @param domain the parameter domain
	 * @param interfaceName the parameter interfaceName
	 * @param operation the parameter operation
	 * @return promise for asynchronous handling
	 */
	public Promise<RemoveMediatorAccessControlEntryDeferred> removeMediatorAccessControlEntry(
			String uid,
			String domain,
			String interfaceName,
			String operation
	);

	/**
	 * updateOwnerAccessControlEntry
	 * @param updatedOwnerAce the parameter updatedOwnerAce
	 * @return promise for asynchronous handling
	 */
	public Promise<UpdateOwnerAccessControlEntryDeferred> updateOwnerAccessControlEntry(
			OwnerAccessControlEntry updatedOwnerAce
	);

	/**
	 * removeOwnerAccessControlEntry
	 * @param uid the parameter uid
	 * @param domain the parameter domain
	 * @param interfaceName the parameter interfaceName
	 * @param operation the parameter operation
	 * @return promise for asynchronous handling
	 */
	public Promise<RemoveOwnerAccessControlEntryDeferred> removeOwnerAccessControlEntry(
			String uid,
			String domain,
			String interfaceName,
			String operation
	);

	/**
	 * updateMasterRegistrationControlEntry
	 * @param updatedMasterRce the parameter updatedMasterRce
	 * @return promise for asynchronous handling
	 */
	public Promise<UpdateMasterRegistrationControlEntryDeferred> updateMasterRegistrationControlEntry(
			MasterRegistrationControlEntry updatedMasterRce
	);

	/**
	 * removeMasterRegistrationControlEntry
	 * @param uid the parameter uid
	 * @param domain the parameter domain
	 * @param interfaceName the parameter interfaceName
	 * @return promise for asynchronous handling
	 */
	public Promise<RemoveMasterRegistrationControlEntryDeferred> removeMasterRegistrationControlEntry(
			String uid,
			String domain,
			String interfaceName
	);

	/**
	 * updateMediatorRegistrationControlEntry
	 * @param updatedMediatorRce the parameter updatedMediatorRce
	 * @return promise for asynchronous handling
	 */
	public Promise<UpdateMediatorRegistrationControlEntryDeferred> updateMediatorRegistrationControlEntry(
			MasterRegistrationControlEntry updatedMediatorRce
	);

	/**
	 * removeMediatorRegistrationControlEntry
	 * @param uid the parameter uid
	 * @param domain the parameter domain
	 * @param interfaceName the parameter interfaceName
	 * @return promise for asynchronous handling
	 */
	public Promise<RemoveMediatorRegistrationControlEntryDeferred> removeMediatorRegistrationControlEntry(
			String uid,
			String domain,
			String interfaceName
	);

	/**
	 * updateOwnerRegistrationControlEntry
	 * @param updatedOwnerRce the parameter updatedOwnerRce
	 * @return promise for asynchronous handling
	 */
	public Promise<UpdateOwnerRegistrationControlEntryDeferred> updateOwnerRegistrationControlEntry(
			OwnerRegistrationControlEntry updatedOwnerRce
	);

	/**
	 * removeOwnerRegistrationControlEntry
	 * @param uid the parameter uid
	 * @param domain the parameter domain
	 * @param interfaceName the parameter interfaceName
	 * @return promise for asynchronous handling
	 */
	public Promise<RemoveOwnerRegistrationControlEntryDeferred> removeOwnerRegistrationControlEntry(
			String uid,
			String domain,
			String interfaceName
	);

	public class UpdateMasterAccessControlEntryDeferred extends AbstractDeferred {
		public synchronized boolean resolve(Boolean success) {
			return super.resolve(success);
		}
	}

	public class RemoveMasterAccessControlEntryDeferred extends AbstractDeferred {
		public synchronized boolean resolve(Boolean success) {
			return super.resolve(success);
		}
	}

	public class UpdateMediatorAccessControlEntryDeferred extends AbstractDeferred {
		public synchronized boolean resolve(Boolean success) {
			return super.resolve(success);
		}
	}

	public class RemoveMediatorAccessControlEntryDeferred extends AbstractDeferred {
		public synchronized boolean resolve(Boolean success) {
			return super.resolve(success);
		}
	}

	public class UpdateOwnerAccessControlEntryDeferred extends AbstractDeferred {
		public synchronized boolean resolve(Boolean success) {
			return super.resolve(success);
		}
	}

	public class RemoveOwnerAccessControlEntryDeferred extends AbstractDeferred {
		public synchronized boolean resolve(Boolean success) {
			return super.resolve(success);
		}
	}

	public class UpdateMasterRegistrationControlEntryDeferred extends AbstractDeferred {
		public synchronized boolean resolve(Boolean success) {
			return super.resolve(success);
		}
	}

	public class RemoveMasterRegistrationControlEntryDeferred extends AbstractDeferred {
		public synchronized boolean resolve(Boolean success) {
			return super.resolve(success);
		}
	}

	public class UpdateMediatorRegistrationControlEntryDeferred extends AbstractDeferred {
		public synchronized boolean resolve(Boolean success) {
			return super.resolve(success);
		}
	}

	public class RemoveMediatorRegistrationControlEntryDeferred extends AbstractDeferred {
		public synchronized boolean resolve(Boolean success) {
			return super.resolve(success);
		}
	}

	public class UpdateOwnerRegistrationControlEntryDeferred extends AbstractDeferred {
		public synchronized boolean resolve(Boolean success) {
			return super.resolve(success);
		}
	}

	public class RemoveOwnerRegistrationControlEntryDeferred extends AbstractDeferred {
		public synchronized boolean resolve(Boolean success) {
			return super.resolve(success);
		}
	}
}
