/*
 *
 * Copyright (C) 2011 - 2018 BMW Car IT GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// #####################################################
//#######################################################
//###                                                 ###
//##    WARNING: This file is generated. DO NOT EDIT   ##
//##             All changes will be lost!             ##
//###                                                 ###
//#######################################################
// #####################################################
package joynr.infrastructure;

import io.joynr.messaging.MessagingQos;
import io.joynr.proxy.Callback;
import io.joynr.proxy.ICallbackWithModeledError;
import io.joynr.proxy.CallbackWithModeledError;
import io.joynr.proxy.Future;
import io.joynr.dispatcher.rpc.annotation.JoynrRpcCallback;
import io.joynr.Async;
import io.joynr.ProvidedBy;
import io.joynr.UsedBy;

import joynr.types.GlobalDiscoveryEntry;


@Async
@ProvidedBy(GlobalCapabilitiesDirectoryProvider.class)
@UsedBy(GlobalCapabilitiesDirectoryProxy.class)
public interface GlobalCapabilitiesDirectoryAsync extends GlobalCapabilitiesDirectory {





	/*
	* add
	*/
	public Future<Void> add(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			GlobalDiscoveryEntry[] globalDiscoveryEntries
	);
	default public Future<Void> add(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			GlobalDiscoveryEntry[] globalDiscoveryEntries,
			MessagingQos messagingQos
	) {
		return add(
			callback,
			globalDiscoveryEntries
		);
	}


	/*
	* add
	*/
	public Future<Void> add(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			GlobalDiscoveryEntry globalDiscoveryEntry
	);
	default public Future<Void> add(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			GlobalDiscoveryEntry globalDiscoveryEntry,
			MessagingQos messagingQos
	) {
		return add(
			callback,
			globalDiscoveryEntry
		);
	}


	/*
	* add
	*/
	public Future<Void> add(
			@JoynrRpcCallback(deserializationType = Void.class) CallbackWithModeledError<Void,joynr.types.DiscoveryError> callback,
			GlobalDiscoveryEntry globalDiscoveryEntry,
			String[] gbids
	);
	default public Future<Void> add(
			@JoynrRpcCallback(deserializationType = Void.class) CallbackWithModeledError<Void,joynr.types.DiscoveryError> callback,
			GlobalDiscoveryEntry globalDiscoveryEntry,
			String[] gbids,
			MessagingQos messagingQos
	) {
		return add(
			callback,
			globalDiscoveryEntry,
			gbids
		);
	}


	/*
	* lookup
	*/
	public Future<GlobalDiscoveryEntry[]> lookup(
			@JoynrRpcCallback(deserializationType = GlobalDiscoveryEntry[].class) Callback<GlobalDiscoveryEntry[]> callback,
			String[] domains,
			String interfaceName
	);
	default public Future<GlobalDiscoveryEntry[]> lookup(
			@JoynrRpcCallback(deserializationType = GlobalDiscoveryEntry[].class) Callback<GlobalDiscoveryEntry[]> callback,
			String[] domains,
			String interfaceName,
			MessagingQos messagingQos
	) {
		return lookup(
			callback,
			domains,
			interfaceName
		);
	}


	/*
	* lookup
	*/
	public Future<GlobalDiscoveryEntry[]> lookup(
			@JoynrRpcCallback(deserializationType = GlobalDiscoveryEntry[].class) CallbackWithModeledError<GlobalDiscoveryEntry[],joynr.types.DiscoveryError> callback,
			String[] domains,
			String interfaceName,
			String[] gbids
	);
	default public Future<GlobalDiscoveryEntry[]> lookup(
			@JoynrRpcCallback(deserializationType = GlobalDiscoveryEntry[].class) CallbackWithModeledError<GlobalDiscoveryEntry[],joynr.types.DiscoveryError> callback,
			String[] domains,
			String interfaceName,
			String[] gbids,
			MessagingQos messagingQos
	) {
		return lookup(
			callback,
			domains,
			interfaceName,
			gbids
		);
	}


	/*
	* lookup
	*/
	public Future<GlobalDiscoveryEntry> lookup(
			@JoynrRpcCallback(deserializationType = GlobalDiscoveryEntry.class) Callback<GlobalDiscoveryEntry> callback,
			String participantId
	);
	default public Future<GlobalDiscoveryEntry> lookup(
			@JoynrRpcCallback(deserializationType = GlobalDiscoveryEntry.class) Callback<GlobalDiscoveryEntry> callback,
			String participantId,
			MessagingQos messagingQos
	) {
		return lookup(
			callback,
			participantId
		);
	}


	/*
	* lookup
	*/
	public Future<GlobalDiscoveryEntry> lookup(
			@JoynrRpcCallback(deserializationType = GlobalDiscoveryEntry.class) CallbackWithModeledError<GlobalDiscoveryEntry,joynr.types.DiscoveryError> callback,
			String participantId,
			String[] gbids
	);
	default public Future<GlobalDiscoveryEntry> lookup(
			@JoynrRpcCallback(deserializationType = GlobalDiscoveryEntry.class) CallbackWithModeledError<GlobalDiscoveryEntry,joynr.types.DiscoveryError> callback,
			String participantId,
			String[] gbids,
			MessagingQos messagingQos
	) {
		return lookup(
			callback,
			participantId,
			gbids
		);
	}


	/*
	* remove
	*/
	public Future<Void> remove(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String[] participantIds
	);
	default public Future<Void> remove(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String[] participantIds,
			MessagingQos messagingQos
	) {
		return remove(
			callback,
			participantIds
		);
	}


	/*
	* remove
	*/
	public Future<Void> remove(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String participantId
	);
	default public Future<Void> remove(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String participantId,
			MessagingQos messagingQos
	) {
		return remove(
			callback,
			participantId
		);
	}


	/*
	* remove
	*/
	public Future<Void> remove(
			@JoynrRpcCallback(deserializationType = Void.class) CallbackWithModeledError<Void,joynr.types.DiscoveryError> callback,
			String participantId,
			String[] gbids
	);
	default public Future<Void> remove(
			@JoynrRpcCallback(deserializationType = Void.class) CallbackWithModeledError<Void,joynr.types.DiscoveryError> callback,
			String participantId,
			String[] gbids,
			MessagingQos messagingQos
	) {
		return remove(
			callback,
			participantId,
			gbids
		);
	}


	/*
	* removeStale
	*/
	public Future<Void> removeStale(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String clusterControllerId,
			Long maxLastSeenDateMs
	);
	default public Future<Void> removeStale(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String clusterControllerId,
			Long maxLastSeenDateMs,
			MessagingQos messagingQos
	) {
		return removeStale(
			callback,
			clusterControllerId,
			maxLastSeenDateMs
		);
	}


	/*
	* touch
	*/
	public Future<Void> touch(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String clusterControllerId
	);
	default public Future<Void> touch(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String clusterControllerId,
			MessagingQos messagingQos
	) {
		return touch(
			callback,
			clusterControllerId
		);
	}


	/*
	* touch
	*/
	public Future<Void> touch(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String clusterControllerId,
			String[] participantIds
	);
	default public Future<Void> touch(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String clusterControllerId,
			String[] participantIds,
			MessagingQos messagingQos
	) {
		return touch(
			callback,
			clusterControllerId,
			participantIds
		);
	}

}
