		/*
		 *
		 * Copyright (C) 2011 - 2018 BMW Car IT GmbH
		 *
		 * Licensed under the Apache License, Version 2.0 (the "License");
		 * you may not use this file except in compliance with the License.
		 * You may obtain a copy of the License at
		 *
		 *      http://www.apache.org/licenses/LICENSE-2.0
		 *
		 * Unless required by applicable law or agreed to in writing, software
		 * distributed under the License is distributed on an "AS IS" BASIS,
		 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		 * See the License for the specific language governing permissions and
		 * limitations under the License.
		 */
		
		// #####################################################
		//#######################################################
		//###                                                 ###
		//##    WARNING: This file is generated. DO NOT EDIT   ##
		//##             All changes will be lost!             ##
		//###                                                 ###
		//#######################################################
		// #####################################################

package joynr.types;
import java.io.Serializable;

import io.joynr.subtypes.JoynrType;

import joynr.types.DiscoveryEntry;
import joynr.types.ProviderQos;
import joynr.types.Version;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;

// NOTE: serialVersionUID is not defined since we don't support Franca versions right now.
//       The compiler will generate a serialVersionUID based on the class and its members
//       (cf. http://docs.oracle.com/javase/6/docs/platform/serialization/spec/class.html#4100),
//       which is probably more restrictive than what we want.

/**
 * GlobalDiscoveryEntry stores information about a provider instance and extends DiscoveryEntry by adding transport middleware specific address information. GlobalDiscoveryEntry objects are used to register a new provider instance with the backend. In addition, objects of GlobalDiscoveryEntry will be returned by the backend during the arbitration process in order to select a suitable provider for a proxy.
 * @see DiscoveryEntry
 */
@SuppressWarnings("serial")
public class GlobalDiscoveryEntry extends DiscoveryEntry implements Serializable, JoynrType {
	public static final int MAJOR_VERSION = 0;
	public static final int MINOR_VERSION = 0;
	@JsonProperty("address")
	private String address;

	/**
	 * Default Constructor
	 */
	public GlobalDiscoveryEntry() {
		this.address = "";
	}

	/**
	 * Copy constructor
	 *
	 * @param globalDiscoveryEntryObj reference to the object to be copied
	 */
	public GlobalDiscoveryEntry(GlobalDiscoveryEntry globalDiscoveryEntryObj) {
		super(globalDiscoveryEntryObj);
		this.address = globalDiscoveryEntryObj.address;
	}

	/**
	 * Parameterized constructor
	 *
	 * @param providerVersion semantic version information
	 * @param domain the domain to register the provider with
	 * @param interfaceName the name of the provider interface
	 * @param participantId the participant ID of the provider
	 * @param qos the qos of the provider
	 * @param lastSeenDateMs the date in millis since epoch when the source for this provider last contacted the directory
	 * @param expiryDateMs the date in millis since epoch when this entry can be purged from the directory and caches
	 * @param publicKeyId the ID of the public key to be used to encrypt messages to this provider
	 * @param address the serialized transport-middleware-specific address where the provider can be reached. The address is a subclass of <code>Address</code> and is stored as a JSON string.
	 */
	public GlobalDiscoveryEntry(
		Version providerVersion,
		String domain,
		String interfaceName,
		String participantId,
		ProviderQos qos,
		Long lastSeenDateMs,
		Long expiryDateMs,
		String publicKeyId,
		String address
		) {
		super(
				providerVersion,
				domain,
				interfaceName,
				participantId,
				qos,
				lastSeenDateMs,
				expiryDateMs,
				publicKeyId
		);
		this.address = address;
	}

	/**
	 * Gets Address
	 *
	 * @return the serialized transport-middleware-specific address where the provider can be reached. The address is a subclass of <code>Address</code> and is stored as a JSON string.
	 */
	@JsonIgnore
	public String getAddress() {
		return address;
	}

	/**
	 * Sets Address
	 *
	 * @param address the serialized transport-middleware-specific address where the provider can be reached. The address is a subclass of <code>Address</code> and is stored as a JSON string.
	 */
	@JsonIgnore
	public void setAddress(String address) {
		if (address == null) {
			throw new IllegalArgumentException("setting address to null is not allowed");
		}
		this.address = address;
	}


	/**
	 * Stringifies the class
	 *
	 * @return stringified class content
	 */
	@Override
	public String toString() {
		return "GlobalDiscoveryEntry ["
		+ super.toString() + ", "
		+ "address=" + this.address
		+ "]";
	}

	/**
	 * Check for equality
	 *
	 * @param obj Reference to the object to compare to
	 * @return true, if objects are equal, false otherwise
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		if (!super.equals(obj))
			return false;
		GlobalDiscoveryEntry other = (GlobalDiscoveryEntry) obj;
		if (this.address == null) {
			if (other.address != null) {
				return false;
			}
		} else if (!this.address.equals(other.address)) {
			return false;
		}
		return true;
	}

	/**
	 * Calculate code for hashing based on member contents
	 *
	 * @return The calculated hash code
	 */
	@Override
	public int hashCode() {
		int result = super.hashCode();
		final int prime = 31;
		result = prime * result + ((this.address == null) ? 0 : this.address.hashCode());
		return result;
	}
}

	
