		/*
		 *
		 * Copyright (C) 2011 - 2018 BMW Car IT GmbH
		 *
		 * Licensed under the Apache License, Version 2.0 (the "License");
		 * you may not use this file except in compliance with the License.
		 * You may obtain a copy of the License at
		 *
		 *      http://www.apache.org/licenses/LICENSE-2.0
		 *
		 * Unless required by applicable law or agreed to in writing, software
		 * distributed under the License is distributed on an "AS IS" BASIS,
		 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		 * See the License for the specific language governing permissions and
		 * limitations under the License.
		 */
		
		// #####################################################
		//#######################################################
		//###                                                 ###
		//##    WARNING: This file is generated. DO NOT EDIT   ##
		//##             All changes will be lost!             ##
		//###                                                 ###
		//#######################################################
		// #####################################################

package joynr.infrastructure.DacTypes;
import java.io.Serializable;

import io.joynr.subtypes.JoynrType;

import joynr.infrastructure.DacTypes.OwnerControlEntry;
import joynr.infrastructure.DacTypes.Permission;
import joynr.infrastructure.DacTypes.TrustLevel;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;

// NOTE: serialVersionUID is not defined since we don't support Franca versions right now.
//       The compiler will generate a serialVersionUID based on the class and its members
//       (cf. http://docs.oracle.com/javase/6/docs/platform/serialization/spec/class.html#4100),
//       which is probably more restrictive than what we want.

/**
 * The Owner Access Control Entry (Owner ACE) stores consumer permissions of users for a domain/interface/operation combination. Owner ACEs are stored by the Owner Access Control List (Owner ACL). If UID, domain, interface and operation values of an Owner ACE match the values of an Master ACE, default consumer permissions and TLs of the Master ACE get overwritten by the consumer permissions and TLs of the Owner ACE unless the consumer permissions or TLs conflict with their respective possible consumer permissions and TLs.
 */
@SuppressWarnings("serial")
public class OwnerAccessControlEntry extends OwnerControlEntry implements Serializable, JoynrType {
	public static final int MAJOR_VERSION = 0;
	public static final int MINOR_VERSION = 0;
	@JsonProperty("operation")
	private String operation;
	@JsonProperty("consumerPermission")
	private Permission consumerPermission;

	/**
	 * Default Constructor
	 */
	public OwnerAccessControlEntry() {
		this.operation = "";
		this.consumerPermission = Permission.YES;
	}

	/**
	 * Copy constructor
	 *
	 * @param ownerAccessControlEntryObj reference to the object to be copied
	 */
	public OwnerAccessControlEntry(OwnerAccessControlEntry ownerAccessControlEntryObj) {
		super(ownerAccessControlEntryObj);
		this.operation = ownerAccessControlEntryObj.operation;
		this.consumerPermission = ownerAccessControlEntryObj.consumerPermission;
	}

	/**
	 * Parameterized constructor
	 *
	 * @param uid A unique user ID (UID) this Control Entry (CE) applies to or the wildcard character (asterisk sign) if this CE applies to all users. CEs that use the wildcard character are overruled by specific ones (if they exist).
	 * @param domain The domain this Control Entry (CE) applies to.
	 * @param interfaceName The interface this Control Entry (CE) applies to.
	 * @param requiredTrustLevel The Trust Level (TL) that is needed by the requester in order to get the permission defined in this CE. The TL must be listed in the possible required TLs of the corresponding Master CE. Otherwise this constitutes a conflict.
	 * @param requiredAceChangeTrustLevel The Trust Level (TL) that is needed by the requester in order to create, edit or delete an Owner ACE. The TL must be listed in the possible required CE Change TLs of the corresponding Master CE. Otherwise this constitutes a conflict.
	 * @param operation The operation this Access Control Entry (ACE) applies to or the wildcard character (asterisk sign) if this ACE applies to all operations of the corresponding interface. ACEs that use the wildcard character are overruled by specific ones (if they exist).
	 * @param consumerPermission The consumer permission that applies to the specified domain/interface/operation combination. The permission must be listed in possible consumer permissions of the corresponding Master ACE. Otherwise this constitutes a conflict.
	 */
	public OwnerAccessControlEntry(
		String uid,
		String domain,
		String interfaceName,
		TrustLevel requiredTrustLevel,
		TrustLevel requiredAceChangeTrustLevel,
		String operation,
		Permission consumerPermission
		) {
		super(
				uid,
				domain,
				interfaceName,
				requiredTrustLevel,
				requiredAceChangeTrustLevel
		);
		this.operation = operation;
		this.consumerPermission = consumerPermission;
	}

	/**
	 * Gets Operation
	 *
	 * @return The operation this Access Control Entry (ACE) applies to or the wildcard character (asterisk sign) if this ACE applies to all operations of the corresponding interface. ACEs that use the wildcard character are overruled by specific ones (if they exist).
	 */
	@JsonIgnore
	public String getOperation() {
		return operation;
	}

	/**
	 * Sets Operation
	 *
	 * @param operation The operation this Access Control Entry (ACE) applies to or the wildcard character (asterisk sign) if this ACE applies to all operations of the corresponding interface. ACEs that use the wildcard character are overruled by specific ones (if they exist).
	 */
	@JsonIgnore
	public void setOperation(String operation) {
		if (operation == null) {
			throw new IllegalArgumentException("setting operation to null is not allowed");
		}
		this.operation = operation;
	}

	/**
	 * Gets ConsumerPermission
	 *
	 * @return The consumer permission that applies to the specified domain/interface/operation combination. The permission must be listed in possible consumer permissions of the corresponding Master ACE. Otherwise this constitutes a conflict.
	 */
	@JsonIgnore
	public Permission getConsumerPermission() {
		return consumerPermission;
	}

	/**
	 * Sets ConsumerPermission
	 *
	 * @param consumerPermission The consumer permission that applies to the specified domain/interface/operation combination. The permission must be listed in possible consumer permissions of the corresponding Master ACE. Otherwise this constitutes a conflict.
	 */
	@JsonIgnore
	public void setConsumerPermission(Permission consumerPermission) {
		if (consumerPermission == null) {
			throw new IllegalArgumentException("setting consumerPermission to null is not allowed");
		}
		this.consumerPermission = consumerPermission;
	}


	/**
	 * Stringifies the class
	 *
	 * @return stringified class content
	 */
	@Override
	public String toString() {
		return "OwnerAccessControlEntry ["
		+ super.toString() + ", "
		+ "operation=" + this.operation + ", "
		+ "consumerPermission=" + this.consumerPermission
		+ "]";
	}

	/**
	 * Check for equality
	 *
	 * @param obj Reference to the object to compare to
	 * @return true, if objects are equal, false otherwise
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		if (!super.equals(obj))
			return false;
		OwnerAccessControlEntry other = (OwnerAccessControlEntry) obj;
		if (this.operation == null) {
			if (other.operation != null) {
				return false;
			}
		} else if (!this.operation.equals(other.operation)) {
			return false;
		}
		if (this.consumerPermission == null) {
			if (other.consumerPermission != null) {
				return false;
			}
		} else if (!this.consumerPermission.equals(other.consumerPermission)) {
			return false;
		}
		return true;
	}

	/**
	 * Calculate code for hashing based on member contents
	 *
	 * @return The calculated hash code
	 */
	@Override
	public int hashCode() {
		int result = super.hashCode();
		final int prime = 31;
		result = prime * result + ((this.operation == null) ? 0 : this.operation.hashCode());
		result = prime * result + ((this.consumerPermission == null) ? 0 : this.consumerPermission.hashCode());
		return result;
	}
}

	
