/*
 *
 * Copyright (C) 2011 - 2018 BMW Car IT GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// #####################################################
//#######################################################
//###                                                 ###
//##    WARNING: This file is generated. DO NOT EDIT   ##
//##             All changes will be lost!             ##
//###                                                 ###
//#######################################################
// #####################################################

package joynr.infrastructure;

import io.joynr.messaging.MessagingQos;
import io.joynr.Sync;
import io.joynr.ProvidedBy;
import io.joynr.UsedBy;
import joynr.exceptions.ApplicationException;

import joynr.types.GlobalDiscoveryEntry;

@Sync
@ProvidedBy(GlobalCapabilitiesDirectoryProvider.class)
@UsedBy(GlobalCapabilitiesDirectoryProxy.class)
public interface GlobalCapabilitiesDirectorySync extends GlobalCapabilitiesDirectory {



	/*
	* add
	*/
	public void add(
			GlobalDiscoveryEntry[] globalDiscoveryEntries
	);
	default public void add(
			GlobalDiscoveryEntry[] globalDiscoveryEntries,
			MessagingQos messagingQos
	) {
		return;
	}

	/*
	* add
	*/
	public void add(
			GlobalDiscoveryEntry globalDiscoveryEntry
	);
	default public void add(
			GlobalDiscoveryEntry globalDiscoveryEntry,
			MessagingQos messagingQos
	) {
		return;
	}

	/*
	* add
	*/
	public void add(
			GlobalDiscoveryEntry globalDiscoveryEntry,
			String[] gbids
	) throws ApplicationException;
	default public void add(
			GlobalDiscoveryEntry globalDiscoveryEntry,
			String[] gbids,
			MessagingQos messagingQos
	) throws ApplicationException {
		return;
	}

	/*
	* lookup
	*/
	public GlobalDiscoveryEntry[] lookup(
			String[] domains,
			String interfaceName
	);
	default public GlobalDiscoveryEntry[] lookup(
			String[] domains,
			String interfaceName,
			MessagingQos messagingQos
	) {
		return lookup(
			domains,
			interfaceName
		);
	}

	/*
	* lookup
	*/
	public GlobalDiscoveryEntry[] lookup(
			String[] domains,
			String interfaceName,
			String[] gbids
	) throws ApplicationException;
	default public GlobalDiscoveryEntry[] lookup(
			String[] domains,
			String interfaceName,
			String[] gbids,
			MessagingQos messagingQos
	) throws ApplicationException {
		return lookup(
			domains,
			interfaceName,
			gbids
		);
	}

	/*
	* lookup
	*/
	public GlobalDiscoveryEntry lookup(
			String participantId
	);
	default public GlobalDiscoveryEntry lookup(
			String participantId,
			MessagingQos messagingQos
	) {
		return lookup(
			participantId
		);
	}

	/*
	* lookup
	*/
	public GlobalDiscoveryEntry lookup(
			String participantId,
			String[] gbids
	) throws ApplicationException;
	default public GlobalDiscoveryEntry lookup(
			String participantId,
			String[] gbids,
			MessagingQos messagingQos
	) throws ApplicationException {
		return lookup(
			participantId,
			gbids
		);
	}

	/*
	* remove
	*/
	public void remove(
			String[] participantIds
	);
	default public void remove(
			String[] participantIds,
			MessagingQos messagingQos
	) {
		return;
	}

	/*
	* remove
	*/
	public void remove(
			String participantId
	);
	default public void remove(
			String participantId,
			MessagingQos messagingQos
	) {
		return;
	}

	/*
	* remove
	*/
	public void remove(
			String participantId,
			String[] gbids
	) throws ApplicationException;
	default public void remove(
			String participantId,
			String[] gbids,
			MessagingQos messagingQos
	) throws ApplicationException {
		return;
	}

	/*
	* removeStale
	*/
	public void removeStale(
			String clusterControllerId,
			Long maxLastSeenDateMs
	);
	default public void removeStale(
			String clusterControllerId,
			Long maxLastSeenDateMs,
			MessagingQos messagingQos
	) {
		return;
	}

	/*
	* touch
	*/
	public void touch(
			String clusterControllerId
	);
	default public void touch(
			String clusterControllerId,
			MessagingQos messagingQos
	) {
		return;
	}

	/*
	* touch
	*/
	public void touch(
			String clusterControllerId,
			String[] participantIds
	);
	default public void touch(
			String clusterControllerId,
			String[] participantIds,
			MessagingQos messagingQos
	) {
		return;
	}
}
