/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.provider;

import io.joynr.JoynrVersion;
import io.joynr.provider.JoynrInterface;
import io.joynr.util.AnnotationUtil;
import java.lang.annotation.Annotation;

public class ProviderAnnotations {
    public static String getInterfaceName(Class<?> providerClass) {
        return ProviderAnnotations.getAnnotation(providerClass, JoynrInterface.class).name();
    }

    public static String getInterfaceName(Object provider) {
        return ProviderAnnotations.getInterfaceName(provider.getClass());
    }

    public static Class<?> getProvidedInterface(Object provider) {
        return ProviderAnnotations.getAnnotation(provider.getClass(), JoynrInterface.class).provides();
    }

    public static Class<?> getProviderInterface(Object provider) {
        return ProviderAnnotations.getAnnotation(provider.getClass(), JoynrInterface.class).provider();
    }

    public static int getMajorVersion(Object provider) {
        return ProviderAnnotations.getAnnotation(provider.getClass(), JoynrVersion.class).major();
    }

    public static int getMajorVersion(Class<?> providerClass) {
        return ProviderAnnotations.getAnnotation(providerClass, JoynrVersion.class).major();
    }

    public static int getMinorVersion(Object provider) {
        return ProviderAnnotations.getAnnotation(provider.getClass(), JoynrVersion.class).minor();
    }

    private static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotationType) {
        T annotation = AnnotationUtil.getAnnotation(clazz, annotationType);
        if (annotation == null) {
            throw new IllegalArgumentException("Missing annotation " + annotationType.getName() + " in hierarchy of class " + clazz.getName());
        }
        return annotation;
    }
}

