		/*
		 *
		 * Copyright (C) 2011 - 2018 BMW Car IT GmbH
		 *
		 * Licensed under the Apache License, Version 2.0 (the "License");
		 * you may not use this file except in compliance with the License.
		 * You may obtain a copy of the License at
		 *
		 *      http://www.apache.org/licenses/LICENSE-2.0
		 *
		 * Unless required by applicable law or agreed to in writing, software
		 * distributed under the License is distributed on an "AS IS" BASIS,
		 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		 * See the License for the specific language governing permissions and
		 * limitations under the License.
		 */
		
		// #####################################################
		//#######################################################
		//###                                                 ###
		//##    WARNING: This file is generated. DO NOT EDIT   ##
		//##             All changes will be lost!             ##
		//###                                                 ###
		//#######################################################
		// #####################################################

package joynr.infrastructure.DacTypes;
import java.io.Serializable;

import io.joynr.subtypes.JoynrType;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;

// NOTE: serialVersionUID is not defined since we don't support Franca versions right now.
//       The compiler will generate a serialVersionUID based on the class and its members
//       (cf. http://docs.oracle.com/javase/6/docs/platform/serialization/spec/class.html#4100),
//       which is probably more restrictive than what we want.

/**
 * The Control Entry (CE) stores access permissions of users for a domain/interface combination. It is the base class for <code>MasterControlEntry</code> and <code>OwnerControlEntry</code>.
 */
@SuppressWarnings("serial")
public class ControlEntry implements Serializable, JoynrType {
	public static final int MAJOR_VERSION = 0;
	public static final int MINOR_VERSION = 0;
	@JsonProperty("uid")
	private String uid;
	@JsonProperty("domain")
	private String domain;
	@JsonProperty("interfaceName")
	private String interfaceName;

	/**
	 * Default Constructor
	 */
	public ControlEntry() {
		this.uid = "";
		this.domain = "";
		this.interfaceName = "";
	}

	/**
	 * Copy constructor
	 *
	 * @param controlEntryObj reference to the object to be copied
	 */
	public ControlEntry(ControlEntry controlEntryObj) {
		this.uid = controlEntryObj.uid;
		this.domain = controlEntryObj.domain;
		this.interfaceName = controlEntryObj.interfaceName;
	}

	/**
	 * Parameterized constructor
	 *
	 * @param uid A unique user ID (UID) this Control Entry (CE) applies to or the wildcard character (asterisk sign) if this CE applies to all users. CEs that use the wildcard character are overruled by specific ones (if they exist).
	 * @param domain The domain this Control Entry (CE) applies to.
	 * @param interfaceName The interface this Control Entry (CE) applies to.
	 */
	public ControlEntry(
		String uid,
		String domain,
		String interfaceName
		) {
		this.uid = uid;
		this.domain = domain;
		this.interfaceName = interfaceName;
	}

	/**
	 * Gets Uid
	 *
	 * @return A unique user ID (UID) this Control Entry (CE) applies to or the wildcard character (asterisk sign) if this CE applies to all users. CEs that use the wildcard character are overruled by specific ones (if they exist).
	 */
	@JsonIgnore
	public String getUid() {
		return uid;
	}

	/**
	 * Sets Uid
	 *
	 * @param uid A unique user ID (UID) this Control Entry (CE) applies to or the wildcard character (asterisk sign) if this CE applies to all users. CEs that use the wildcard character are overruled by specific ones (if they exist).
	 */
	@JsonIgnore
	public void setUid(String uid) {
		if (uid == null) {
			throw new IllegalArgumentException("setting uid to null is not allowed");
		}
		this.uid = uid;
	}

	/**
	 * Gets Domain
	 *
	 * @return The domain this Control Entry (CE) applies to.
	 */
	@JsonIgnore
	public String getDomain() {
		return domain;
	}

	/**
	 * Sets Domain
	 *
	 * @param domain The domain this Control Entry (CE) applies to.
	 */
	@JsonIgnore
	public void setDomain(String domain) {
		if (domain == null) {
			throw new IllegalArgumentException("setting domain to null is not allowed");
		}
		this.domain = domain;
	}

	/**
	 * Gets InterfaceName
	 *
	 * @return The interface this Control Entry (CE) applies to.
	 */
	@JsonIgnore
	public String getInterfaceName() {
		return interfaceName;
	}

	/**
	 * Sets InterfaceName
	 *
	 * @param interfaceName The interface this Control Entry (CE) applies to.
	 */
	@JsonIgnore
	public void setInterfaceName(String interfaceName) {
		if (interfaceName == null) {
			throw new IllegalArgumentException("setting interfaceName to null is not allowed");
		}
		this.interfaceName = interfaceName;
	}


	/**
	 * Stringifies the class
	 *
	 * @return stringified class content
	 */
	@Override
	public String toString() {
		return "ControlEntry ["
		+ "uid=" + this.uid + ", "
		+ "domain=" + this.domain + ", "
		+ "interfaceName=" + this.interfaceName
		+ "]";
	}

	/**
	 * Check for equality
	 *
	 * @param obj Reference to the object to compare to
	 * @return true, if objects are equal, false otherwise
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ControlEntry other = (ControlEntry) obj;
		if (this.uid == null) {
			if (other.uid != null) {
				return false;
			}
		} else if (!this.uid.equals(other.uid)) {
			return false;
		}
		if (this.domain == null) {
			if (other.domain != null) {
				return false;
			}
		} else if (!this.domain.equals(other.domain)) {
			return false;
		}
		if (this.interfaceName == null) {
			if (other.interfaceName != null) {
				return false;
			}
		} else if (!this.interfaceName.equals(other.interfaceName)) {
			return false;
		}
		return true;
	}

	/**
	 * Calculate code for hashing based on member contents
	 *
	 * @return The calculated hash code
	 */
	@Override
	public int hashCode() {
		int result = 1;
		final int prime = 31;
		result = prime * result + ((this.uid == null) ? 0 : this.uid.hashCode());
		result = prime * result + ((this.domain == null) ? 0 : this.domain.hashCode());
		result = prime * result + ((this.interfaceName == null) ? 0 : this.interfaceName.hashCode());
		return result;
	}
}

	
