/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public class AnnotationUtil {
    public static Collection<Annotation> getAnnotationsRecursive(Class<?> clazz) {
        HashSet<Annotation> allAnnotations = new HashSet<Annotation>();
        AnnotationUtil.getAllAnnotations(clazz, allAnnotations);
        return allAnnotations;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotationType) {
        return (T)((Annotation)AnnotationUtil.getAnnotationsRecursive(clazz).stream().filter(annotationType::isInstance).map(annotationType::cast).findFirst().orElse(null));
    }

    private static void getAllAnnotations(Class<?> clazz, Collection<Annotation> result) {
        if (clazz == null) {
            return;
        }
        result.addAll(Arrays.asList(clazz.getDeclaredAnnotations()));
        for (Class<?> interfaceClass : clazz.getInterfaces()) {
            AnnotationUtil.getAllAnnotations(interfaceClass, result);
        }
        AnnotationUtil.getAllAnnotations(clazz.getSuperclass(), result);
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> annotationType) {
        T result = method.getAnnotation(annotationType);
        if (result == null) {
            Class<?> superclass = method.getDeclaringClass().getSuperclass();
            if (superclass != null) {
                try {
                    Method supermethod = superclass.getDeclaredMethod(method.getName(), method.getParameterTypes());
                    result = AnnotationUtil.getAnnotation(supermethod, annotationType);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (result == null) {
                for (Class<?> implementedInterface : method.getDeclaringClass().getInterfaces()) {
                    try {
                        Method interfaceMethod = implementedInterface.getMethod(method.getName(), method.getParameterTypes());
                        result = AnnotationUtil.getAnnotation(interfaceMethod, annotationType);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (result != null) break;
                }
            }
        }
        return result;
    }
}

