		/*
		 *
		 * Copyright (C) 2011 - 2018 BMW Car IT GmbH
		 *
		 * Licensed under the Apache License, Version 2.0 (the "License");
		 * you may not use this file except in compliance with the License.
		 * You may obtain a copy of the License at
		 *
		 *      http://www.apache.org/licenses/LICENSE-2.0
		 *
		 * Unless required by applicable law or agreed to in writing, software
		 * distributed under the License is distributed on an "AS IS" BASIS,
		 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		 * See the License for the specific language governing permissions and
		 * limitations under the License.
		 */
		
		// #####################################################
		//#######################################################
		//###                                                 ###
		//##    WARNING: This file is generated. DO NOT EDIT   ##
		//##             All changes will be lost!             ##
		//###                                                 ###
		//#######################################################
		// #####################################################

package joynr.infrastructure.DacTypes;
import java.io.Serializable;

import io.joynr.subtypes.JoynrType;

import joynr.infrastructure.DacTypes.OwnerControlEntry;
import joynr.infrastructure.DacTypes.Permission;
import joynr.infrastructure.DacTypes.TrustLevel;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;

// NOTE: serialVersionUID is not defined since we don't support Franca versions right now.
//       The compiler will generate a serialVersionUID based on the class and its members
//       (cf. http://docs.oracle.com/javase/6/docs/platform/serialization/spec/class.html#4100),
//       which is probably more restrictive than what we want.

/**
 * The Owner Registration Control Entry (Owner RCE) stores provider permissions of users for a domain/interface combination. Owner RCEs are stored by the Owner Registration Control List (Owner RCL). If UIDs, domain and interface values of an Owner RCE match the values of an Master RCE, default provider permissions and TLs of the Master RCE get overwritten by the permissions and TLs of the Owner RCE unless the permissions or TLs conflict with their respective possible permissions and TLs.
 */
@SuppressWarnings("serial")
public class OwnerRegistrationControlEntry extends OwnerControlEntry implements Serializable, JoynrType {
	public static final int MAJOR_VERSION = 0;
	public static final int MINOR_VERSION = 0;
	@JsonProperty("providerPermission")
	private Permission providerPermission;

	/**
	 * Default Constructor
	 */
	public OwnerRegistrationControlEntry() {
		this.providerPermission = Permission.YES;
	}

	/**
	 * Copy constructor
	 *
	 * @param ownerRegistrationControlEntryObj reference to the object to be copied
	 */
	public OwnerRegistrationControlEntry(OwnerRegistrationControlEntry ownerRegistrationControlEntryObj) {
		super(ownerRegistrationControlEntryObj);
		this.providerPermission = ownerRegistrationControlEntryObj.providerPermission;
	}

	/**
	 * Parameterized constructor
	 *
	 * @param uid A unique user ID (UID) this Control Entry (CE) applies to or the wildcard character (asterisk sign) if this CE applies to all users. CEs that use the wildcard character are overruled by specific ones (if they exist).
	 * @param domain The domain this Control Entry (CE) applies to.
	 * @param interfaceName The interface this Control Entry (CE) applies to.
	 * @param requiredTrustLevel The Trust Level (TL) that is needed by the requester in order to get the permission defined in this CE. The TL must be listed in the possible required TLs of the corresponding Master CE. Otherwise this constitutes a conflict.
	 * @param requiredAceChangeTrustLevel The Trust Level (TL) that is needed by the requester in order to create, edit or delete an Owner ACE. The TL must be listed in the possible required CE Change TLs of the corresponding Master CE. Otherwise this constitutes a conflict.
	 * @param providerPermission The provider permission that applies to the specified domain/interface/operations combination. The permission must be listed in possible provider permissions of the corresponding Master ACE. Otherwise this constitutes a conflict.
	 */
	public OwnerRegistrationControlEntry(
		String uid,
		String domain,
		String interfaceName,
		TrustLevel requiredTrustLevel,
		TrustLevel requiredAceChangeTrustLevel,
		Permission providerPermission
		) {
		super(
				uid,
				domain,
				interfaceName,
				requiredTrustLevel,
				requiredAceChangeTrustLevel
		);
		this.providerPermission = providerPermission;
	}

	/**
	 * Gets ProviderPermission
	 *
	 * @return The provider permission that applies to the specified domain/interface/operations combination. The permission must be listed in possible provider permissions of the corresponding Master ACE. Otherwise this constitutes a conflict.
	 */
	@JsonIgnore
	public Permission getProviderPermission() {
		return providerPermission;
	}

	/**
	 * Sets ProviderPermission
	 *
	 * @param providerPermission The provider permission that applies to the specified domain/interface/operations combination. The permission must be listed in possible provider permissions of the corresponding Master ACE. Otherwise this constitutes a conflict.
	 */
	@JsonIgnore
	public void setProviderPermission(Permission providerPermission) {
		if (providerPermission == null) {
			throw new IllegalArgumentException("setting providerPermission to null is not allowed");
		}
		this.providerPermission = providerPermission;
	}


	/**
	 * Stringifies the class
	 *
	 * @return stringified class content
	 */
	@Override
	public String toString() {
		return "OwnerRegistrationControlEntry ["
		+ super.toString() + ", "
		+ "providerPermission=" + this.providerPermission
		+ "]";
	}

	/**
	 * Check for equality
	 *
	 * @param obj Reference to the object to compare to
	 * @return true, if objects are equal, false otherwise
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		if (!super.equals(obj))
			return false;
		OwnerRegistrationControlEntry other = (OwnerRegistrationControlEntry) obj;
		if (this.providerPermission == null) {
			if (other.providerPermission != null) {
				return false;
			}
		} else if (!this.providerPermission.equals(other.providerPermission)) {
			return false;
		}
		return true;
	}

	/**
	 * Calculate code for hashing based on member contents
	 *
	 * @return The calculated hash code
	 */
	@Override
	public int hashCode() {
		int result = super.hashCode();
		final int prime = 31;
		result = prime * result + ((this.providerPermission == null) ? 0 : this.providerPermission.hashCode());
		return result;
	}
}

	
