/*
 *
 * Copyright (C) 2011 - 2018 BMW Car IT GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// #####################################################
//#######################################################
//###                                                 ###
//##    WARNING: This file is generated. DO NOT EDIT   ##
//##             All changes will be lost!             ##
//###                                                 ###
//#######################################################
// #####################################################

package joynr.infrastructure.DacTypes;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

/**
 * A Trust Level (TL) describes the trustworthiness of a joynr user and the device he uses to connect to the joynr backend or other joynr participants. There are four levels of trustworthiness: HIGH, MID, LOW and NONE. Note that NONE refers to a completely untrusted, non-authenticated user. All other TLs are specified by requirements regarding the device used to establish a connection (e.g. vehicle, mobile phone, etc.) and the local authentication methods unlocking a user???s certificate (e.g. passwords, biometric authentication, etc.).
 */
public enum TrustLevel {
	/**
	 * description missing in Franca model.
	 */
	HIGH,
		/**
	 * description missing in Franca model.
	 */
	MID,
		/**
	 * description missing in Franca model.
	 */
	LOW,
		/**
	 * description missing in Franca model.
	 */
	NONE
	;

	public static final int MAJOR_VERSION = 0;
	public static final int MINOR_VERSION = 0;
	static final Map<Integer, TrustLevel> ordinalToEnumValues = new HashMap<>();

	static {
		ordinalToEnumValues.put(0, HIGH);
		ordinalToEnumValues.put(1, MID);
		ordinalToEnumValues.put(2, LOW);
		ordinalToEnumValues.put(3, NONE);
	}

	/**
	 * Get the matching enum for an ordinal number
	 * @param ordinal The ordinal number
	 * @return The matching enum for the given ordinal number
	 */
	public static TrustLevel getEnumValue(Integer ordinal) {
		return ordinalToEnumValues.get(ordinal);
	}

	/**
	 * Get the matching ordinal number for this enum
	 * @return The ordinal number representing this enum
	 */
	public Integer getOrdinal() {
		// TODO should we use a bidirectional map from a third-party library?
		Integer ordinal = null;
		for (Entry<Integer, TrustLevel> entry : ordinalToEnumValues.entrySet()) {
			if (this == entry.getValue()) {
				ordinal = entry.getKey();
				break;
			}
		}
		return ordinal;
	}
}
