/*
 *
 * Copyright (C) 2011 - 2018 BMW Car IT GmbH
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// #####################################################
//#######################################################
//###                                                 ###
//##    WARNING: This file is generated. DO NOT EDIT   ##
//##             All changes will be lost!             ##
//###                                                 ###
//#######################################################
// #####################################################
package joynr.system;

import io.joynr.messaging.MessagingQos;
import io.joynr.proxy.Callback;
import io.joynr.proxy.Future;
import io.joynr.dispatcher.rpc.annotation.JoynrRpcCallback;
import io.joynr.Async;
import io.joynr.ProvidedBy;
import io.joynr.UsedBy;

import joynr.system.RoutingTypes.BinderAddress;
import joynr.system.RoutingTypes.BrowserAddress;
import joynr.system.RoutingTypes.ChannelAddress;
import joynr.system.RoutingTypes.MqttAddress;
import joynr.system.RoutingTypes.UdsAddress;
import joynr.system.RoutingTypes.UdsClientAddress;
import joynr.system.RoutingTypes.WebSocketAddress;
import joynr.system.RoutingTypes.WebSocketClientAddress;


@Async
@ProvidedBy(RoutingProvider.class)
@UsedBy(RoutingProxy.class)
public interface RoutingAsync extends Routing {

	public Future<String> getGlobalAddress(@JoynrRpcCallback(deserializationType = String.class) Callback<String> callback);
	default public Future<String> getGlobalAddress(@JoynrRpcCallback(deserializationType = String.class) Callback<String> callback, MessagingQos messagingQos) {
		return getGlobalAddress(callback);
	}
	public Future<String> getReplyToAddress(@JoynrRpcCallback(deserializationType = String.class) Callback<String> callback);
	default public Future<String> getReplyToAddress(@JoynrRpcCallback(deserializationType = String.class) Callback<String> callback, MessagingQos messagingQos) {
		return getReplyToAddress(callback);
	}




	/*
	* addNextHop
	*/
	public Future<Void> addNextHop(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String participantId,
			ChannelAddress channelAddress,
			Boolean isGloballyVisible
	);
	default public Future<Void> addNextHop(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String participantId,
			ChannelAddress channelAddress,
			Boolean isGloballyVisible,
			MessagingQos messagingQos
	) {
		return addNextHop(
			callback,
			participantId,
			channelAddress,
			isGloballyVisible
		);
	}


	/*
	* addNextHop
	*/
	public Future<Void> addNextHop(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String participantId,
			MqttAddress mqttAddress,
			Boolean isGloballyVisible
	);
	default public Future<Void> addNextHop(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String participantId,
			MqttAddress mqttAddress,
			Boolean isGloballyVisible,
			MessagingQos messagingQos
	) {
		return addNextHop(
			callback,
			participantId,
			mqttAddress,
			isGloballyVisible
		);
	}


	/*
	* addNextHop
	*/
	public Future<Void> addNextHop(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String participantId,
			BrowserAddress browserAddress,
			Boolean isGloballyVisible
	);
	default public Future<Void> addNextHop(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String participantId,
			BrowserAddress browserAddress,
			Boolean isGloballyVisible,
			MessagingQos messagingQos
	) {
		return addNextHop(
			callback,
			participantId,
			browserAddress,
			isGloballyVisible
		);
	}


	/*
	* addNextHop
	*/
	public Future<Void> addNextHop(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String participantId,
			WebSocketAddress webSocketAddress,
			Boolean isGloballyVisible
	);
	default public Future<Void> addNextHop(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String participantId,
			WebSocketAddress webSocketAddress,
			Boolean isGloballyVisible,
			MessagingQos messagingQos
	) {
		return addNextHop(
			callback,
			participantId,
			webSocketAddress,
			isGloballyVisible
		);
	}


	/*
	* addNextHop
	*/
	public Future<Void> addNextHop(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String participantId,
			UdsAddress udsAddress,
			Boolean isGloballyVisible
	);
	default public Future<Void> addNextHop(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String participantId,
			UdsAddress udsAddress,
			Boolean isGloballyVisible,
			MessagingQos messagingQos
	) {
		return addNextHop(
			callback,
			participantId,
			udsAddress,
			isGloballyVisible
		);
	}


	/*
	* addNextHop
	*/
	public Future<Void> addNextHop(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String participantId,
			BinderAddress binderAddress,
			Boolean isGloballyVisible
	);
	default public Future<Void> addNextHop(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String participantId,
			BinderAddress binderAddress,
			Boolean isGloballyVisible,
			MessagingQos messagingQos
	) {
		return addNextHop(
			callback,
			participantId,
			binderAddress,
			isGloballyVisible
		);
	}


	/*
	* addNextHop
	*/
	public Future<Void> addNextHop(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String participantId,
			WebSocketClientAddress webSocketClientAddress,
			Boolean isGloballyVisible
	);
	default public Future<Void> addNextHop(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String participantId,
			WebSocketClientAddress webSocketClientAddress,
			Boolean isGloballyVisible,
			MessagingQos messagingQos
	) {
		return addNextHop(
			callback,
			participantId,
			webSocketClientAddress,
			isGloballyVisible
		);
	}


	/*
	* addNextHop
	*/
	public Future<Void> addNextHop(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String participantId,
			UdsClientAddress udsClientAddress,
			Boolean isGloballyVisible
	);
	default public Future<Void> addNextHop(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String participantId,
			UdsClientAddress udsClientAddress,
			Boolean isGloballyVisible,
			MessagingQos messagingQos
	) {
		return addNextHop(
			callback,
			participantId,
			udsClientAddress,
			isGloballyVisible
		);
	}


	/*
	* removeNextHop
	*/
	public Future<Void> removeNextHop(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String participantId
	);
	default public Future<Void> removeNextHop(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String participantId,
			MessagingQos messagingQos
	) {
		return removeNextHop(
			callback,
			participantId
		);
	}


	/*
	* resolveNextHop
	*/
	public Future<Boolean> resolveNextHop(
			@JoynrRpcCallback(deserializationType = Boolean.class) Callback<Boolean> callback,
			String participantId
	);
	default public Future<Boolean> resolveNextHop(
			@JoynrRpcCallback(deserializationType = Boolean.class) Callback<Boolean> callback,
			String participantId,
			MessagingQos messagingQos
	) {
		return resolveNextHop(
			callback,
			participantId
		);
	}


	/*
	* addMulticastReceiver
	*/
	public Future<Void> addMulticastReceiver(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String multicastId,
			String subscriberParticipantId,
			String providerParticipantId
	);
	default public Future<Void> addMulticastReceiver(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String multicastId,
			String subscriberParticipantId,
			String providerParticipantId,
			MessagingQos messagingQos
	) {
		return addMulticastReceiver(
			callback,
			multicastId,
			subscriberParticipantId,
			providerParticipantId
		);
	}


	/*
	* removeMulticastReceiver
	*/
	public Future<Void> removeMulticastReceiver(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String multicastId,
			String subscriberParticipantId,
			String providerParticipantId
	);
	default public Future<Void> removeMulticastReceiver(
			@JoynrRpcCallback(deserializationType = Void.class) Callback<Void> callback,
			String multicastId,
			String subscriberParticipantId,
			String providerParticipantId,
			MessagingQos messagingQos
	) {
		return removeMulticastReceiver(
			callback,
			multicastId,
			subscriberParticipantId,
			providerParticipantId
		);
	}

}
