		/*
		 *
		 * Copyright (C) 2011 - 2018 BMW Car IT GmbH
		 *
		 * Licensed under the Apache License, Version 2.0 (the "License");
		 * you may not use this file except in compliance with the License.
		 * You may obtain a copy of the License at
		 *
		 *      http://www.apache.org/licenses/LICENSE-2.0
		 *
		 * Unless required by applicable law or agreed to in writing, software
		 * distributed under the License is distributed on an "AS IS" BASIS,
		 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
		 * See the License for the specific language governing permissions and
		 * limitations under the License.
		 */
		
		// #####################################################
		//#######################################################
		//###                                                 ###
		//##    WARNING: This file is generated. DO NOT EDIT   ##
		//##             All changes will be lost!             ##
		//###                                                 ###
		//#######################################################
		// #####################################################

package joynr.system.RoutingTypes;
import java.io.Serializable;

import io.joynr.subtypes.JoynrType;

import joynr.system.RoutingTypes.LocalAddress;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;

// NOTE: serialVersionUID is not defined since we don't support Franca versions right now.
//       The compiler will generate a serialVersionUID based on the class and its members
//       (cf. http://docs.oracle.com/javase/6/docs/platform/serialization/spec/class.html#4100),
//       which is probably more restrictive than what we want.

/**
 * Unix domain socket server address
 */
@SuppressWarnings("serial")
public class UdsAddress extends LocalAddress implements Serializable, JoynrType {
	public static final int MAJOR_VERSION = 0;
	public static final int MINOR_VERSION = 0;
	@JsonProperty("path")
	private String path;

	/**
	 * Default Constructor
	 */
	public UdsAddress() {
		this.path = "";
	}

	/**
	 * Copy constructor
	 *
	 * @param udsAddressObj reference to the object to be copied
	 */
	public UdsAddress(UdsAddress udsAddressObj) {
		super(udsAddressObj);
		this.path = udsAddressObj.path;
	}

	/**
	 * Parameterized constructor
	 *
	 * @param path Unix domain socket server path
	 */
	public UdsAddress(
		String path
		) {
		super(
		);
		this.path = path;
	}

	/**
	 * Gets Path
	 *
	 * @return Unix domain socket server path
	 */
	@JsonIgnore
	public String getPath() {
		return path;
	}

	/**
	 * Sets Path
	 *
	 * @param path Unix domain socket server path
	 */
	@JsonIgnore
	public void setPath(String path) {
		if (path == null) {
			throw new IllegalArgumentException("setting path to null is not allowed");
		}
		this.path = path;
	}


	/**
	 * Stringifies the class
	 *
	 * @return stringified class content
	 */
	@Override
	public String toString() {
		return "UdsAddress ["
		+ super.toString() + ", "
		+ "path=" + this.path
		+ "]";
	}

	/**
	 * Check for equality
	 *
	 * @param obj Reference to the object to compare to
	 * @return true, if objects are equal, false otherwise
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		if (!super.equals(obj))
			return false;
		UdsAddress other = (UdsAddress) obj;
		if (this.path == null) {
			if (other.path != null) {
				return false;
			}
		} else if (!this.path.equals(other.path)) {
			return false;
		}
		return true;
	}

	/**
	 * Calculate code for hashing based on member contents
	 *
	 * @return The calculated hash code
	 */
	@Override
	public int hashCode() {
		int result = super.hashCode();
		final int prime = 31;
		result = prime * result + ((this.path == null) ? 0 : this.path.hashCode());
		return result;
	}
}

	
