/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.exceptions;

import io.joynr.exceptions.DiscoveryException;
import io.joynr.exceptions.NoCompatibleProviderFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import joynr.types.Version;

public class MultiDomainNoCompatibleProviderFoundException
extends DiscoveryException {
    private static final long serialVersionUID = 1L;
    private final Map<String, NoCompatibleProviderFoundException> exceptionsByDomain;

    public MultiDomainNoCompatibleProviderFoundException(Map<String, NoCompatibleProviderFoundException> exceptionsByDomain) {
        super("MultiDomainNoCompatibleProviderFoundException");
        this.exceptionsByDomain = exceptionsByDomain != null ? new HashMap<String, NoCompatibleProviderFoundException>(exceptionsByDomain) : null;
    }

    public Map<String, NoCompatibleProviderFoundException> getExceptionsByDomain() {
        return this.exceptionsByDomain != null ? new HashMap<String, NoCompatibleProviderFoundException>(this.exceptionsByDomain) : null;
    }

    public Set<String> getDomainsWithExceptions() {
        return this.exceptionsByDomain.keySet();
    }

    public boolean hasExceptionForDomain(String domain) {
        return this.exceptionsByDomain.containsKey(domain);
    }

    public NoCompatibleProviderFoundException getExceptionForDomain(String domain) {
        return this.exceptionsByDomain.get(domain);
    }

    public Set<Version> getDiscoveredVersionsForDomain(String domain) {
        HashSet<Version> result = new HashSet<Version>();
        if (this.hasExceptionForDomain(domain)) {
            result.addAll(this.exceptionsByDomain.get(domain).getDiscoveredVersions());
        }
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.exceptionsByDomain == null ? 0 : this.exceptionsByDomain.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiDomainNoCompatibleProviderFoundException other = (MultiDomainNoCompatibleProviderFoundException)obj;
        return !(this.exceptionsByDomain == null ? other.exceptionsByDomain != null : !this.exceptionsByDomain.equals(other.exceptionsByDomain));
    }
}

