/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.exceptions;

import io.joynr.exceptions.DiscoveryException;
import java.util.HashSet;
import java.util.Set;
import joynr.types.Version;

public class NoCompatibleProviderFoundException
extends DiscoveryException {
    private static final long serialVersionUID = 1L;
    private final String interfaceName;
    private final Version interfaceVersion;
    private final Set<Version> discoveredVersions;
    private final String domain;

    public NoCompatibleProviderFoundException(String interfaceName, Version interfaceVersion, String domain, Set<Version> discoveredVersions) {
        super(String.format("Unable to find a provider for %s %s in domain %s with a compatible version.%nVersions found: %s", interfaceName, interfaceVersion, domain, discoveredVersions));
        this.interfaceName = interfaceName;
        this.interfaceVersion = interfaceVersion != null ? new Version(interfaceVersion) : null;
        this.domain = domain;
        this.discoveredVersions = discoveredVersions != null ? new HashSet<Version>(discoveredVersions) : null;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public Version getInterfaceVersion() {
        return this.interfaceVersion != null ? new Version(this.interfaceVersion) : null;
    }

    public String getDomain() {
        return this.domain;
    }

    public Set<Version> getDiscoveredVersions() {
        return this.discoveredVersions != null ? new HashSet<Version>(this.discoveredVersions) : null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.discoveredVersions == null ? 0 : this.discoveredVersions.hashCode());
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        result = 31 * result + (this.interfaceName == null ? 0 : this.interfaceName.hashCode());
        result = 31 * result + (this.interfaceVersion == null ? 0 : this.interfaceVersion.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NoCompatibleProviderFoundException other = (NoCompatibleProviderFoundException)obj;
        if (this.discoveredVersions == null ? other.discoveredVersions != null : !this.discoveredVersions.equals(other.discoveredVersions)) {
            return false;
        }
        if (this.domain == null ? other.domain != null : !this.domain.equals(other.domain)) {
            return false;
        }
        if (this.interfaceName == null ? other.interfaceName != null : !this.interfaceName.equals(other.interfaceName)) {
            return false;
        }
        return !(this.interfaceVersion == null ? other.interfaceVersion != null : !this.interfaceVersion.equals(other.interfaceVersion));
    }
}

