/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.messaging;

import io.joynr.messaging.MessagingQosEffort;
import java.util.HashMap;
import java.util.Map;

public class MessagingQos {
    public static final int DEFAULT_TTL = 60000;
    public static final Map<String, String> DEFAULTQOS = new HashMap<String, String>();
    private long ttl_ms;
    private Map<String, String> customHeaders = new HashMap<String, String>();
    private MessagingQosEffort effort;
    private boolean encrypt;
    private boolean compress = false;

    public MessagingQos(MessagingQos src) {
        this.ttl_ms = src.getRoundTripTtl_ms();
        this.effort = src.getEffort();
        this.encrypt = src.getEncrypt();
        this.compress = src.getCompress();
        this.customHeaders = src.customHeaders != null ? new HashMap<String, String>(src.customHeaders) : null;
    }

    public MessagingQos() {
        this(60000L);
    }

    public MessagingQos(long ttl_ms) {
        this(ttl_ms, MessagingQosEffort.NORMAL);
    }

    public MessagingQos(long ttl_ms, MessagingQosEffort effort) {
        this(ttl_ms, effort, false);
    }

    public MessagingQos(MessagingQosEffort effort) {
        this(60000L, effort, false);
    }

    public MessagingQos(MessagingQosEffort effort, boolean encrypt) {
        this(60000L, effort, encrypt);
    }

    public MessagingQos(boolean encrypt) {
        this(60000L, encrypt);
    }

    public MessagingQos(long ttl_ms, boolean encrypt) {
        this(ttl_ms, MessagingQosEffort.NORMAL, encrypt);
    }

    public MessagingQos(long ttl_ms, MessagingQosEffort effort, boolean encrypt) {
        this.ttl_ms = ttl_ms;
        this.effort = effort;
        this.encrypt = encrypt;
    }

    public MessagingQos(long ttl_ms, MessagingQosEffort effort, Map<String, String> customHeaders, boolean compress) {
        this.ttl_ms = ttl_ms;
        this.effort = effort;
        this.customHeaders = customHeaders != null ? new HashMap<String, String>(customHeaders) : null;
        this.compress = compress;
    }

    public long getRoundTripTtl_ms() {
        return this.ttl_ms;
    }

    public void setTtl_ms(long ttl_ms) {
        this.ttl_ms = ttl_ms;
    }

    public MessagingQosEffort getEffort() {
        return this.effort;
    }

    public void setEffort(MessagingQosEffort effort) {
        this.effort = effort;
    }

    public boolean getEncrypt() {
        return this.encrypt;
    }

    public void setEncrypt(boolean encrypt) {
        this.encrypt = encrypt;
    }

    public boolean getCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public void putCustomMessageHeader(String key, String value) {
        this.checkKeyAndValue(key, value);
        this.customHeaders.put(key, value);
    }

    public void putAllCustomMessageHeaders(Map<String, String> newCustomHeaders) {
        for (Map.Entry<String, String> entry : newCustomHeaders.entrySet()) {
            this.checkKeyAndValue(entry.getKey(), entry.getValue());
        }
        this.customHeaders.putAll(newCustomHeaders);
    }

    private void checkKeyAndValue(String key, String value) {
        String keyPattern = "^[a-zA-Z0-9\\-]*$";
        String valuePattern = "^[a-zA-Z0-9 ;:,+&\\?\\-\\.\\*\\/\\\\_]*$";
        if (!key.matches(keyPattern)) {
            throw new IllegalArgumentException("key may only contain alphanumeric characters");
        }
        if (!value.matches(valuePattern)) {
            throw new IllegalArgumentException("value contains illegal character. See JavaDoc for allowed characters");
        }
    }

    public Map<String, String> getCustomMessageHeaders() {
        return this.customHeaders != null ? new HashMap<String, String>(this.customHeaders) : null;
    }

    public String toString() {
        return "MessagingQos [compress=" + this.compress + ", customHeaders=" + this.customHeaders.toString() + ", effort=" + this.effort.toString() + ", encrypt=" + this.encrypt + ", ttl_ms=" + this.ttl_ms + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.ttl_ms ^ this.ttl_ms >>> 32);
        result = 31 * result + (this.effort == null ? 0 : this.effort.hashCode());
        result = 31 * result + (this.customHeaders == null ? 0 : this.customHeaders.hashCode());
        result = 31 * result + Boolean.hashCode(this.encrypt);
        result = 31 * result + Boolean.hashCode(this.compress);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MessagingQos other = (MessagingQos)obj;
        if (this.ttl_ms != other.ttl_ms) {
            return false;
        }
        if (this.effort != other.effort) {
            return false;
        }
        if (this.encrypt != other.encrypt) {
            return false;
        }
        if (this.compress != other.compress) {
            return false;
        }
        return this.customHeaders.equals(other.customHeaders);
    }
}

