/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.proxy;

import io.joynr.dispatcher.rpc.RequestStatus;
import io.joynr.dispatcher.rpc.RequestStatusCode;
import io.joynr.exceptions.JoynrException;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.exceptions.JoynrWaitExpiredException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import joynr.exceptions.ApplicationException;

public class Future<T> {
    private T value;
    private AtomicReference<JoynrException> exception = new AtomicReference<Object>(null);
    RequestStatus status = new RequestStatus(RequestStatusCode.IN_PROGRESS);
    private Lock statusLock = new ReentrantLock();
    private Condition statusLockChangedCondition = this.statusLock.newCondition();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(long timeoutMs) throws InterruptedException, JoynrWaitExpiredException, ApplicationException, JoynrRuntimeException {
        try {
            this.statusLock.lock();
            if (this.status.getCode() == RequestStatusCode.OK) {
                T t = this.value;
                return t;
            }
            JoynrException e = this.exception.get();
            if (e != null) {
                if (e instanceof ApplicationException) {
                    throw (ApplicationException)e;
                }
                throw (JoynrRuntimeException)e;
            }
            while (RequestStatusCode.IN_PROGRESS.equals((Object)this.status.getCode())) {
                boolean awaitOk = this.statusLockChangedCondition.await(timeoutMs, TimeUnit.MILLISECONDS);
                if (awaitOk) continue;
                this.status.setCode(RequestStatusCode.ERROR);
                throw new JoynrWaitExpiredException();
            }
            e = this.exception.get();
            if (e != null) {
                if (e instanceof ApplicationException) {
                    throw (ApplicationException)e;
                }
                throw (JoynrRuntimeException)e;
            }
            T t = this.value;
            return t;
        }
        finally {
            this.statusLock.unlock();
        }
    }

    public T get() throws InterruptedException, JoynrWaitExpiredException, ApplicationException, JoynrRuntimeException {
        return this.get(Long.MAX_VALUE);
    }

    public RequestStatus getStatus() {
        return new RequestStatus(this.status);
    }

    public void onSuccess(T result) {
        try {
            this.statusLock.lock();
            this.value = result;
            this.status = new RequestStatus(RequestStatusCode.OK);
            this.statusLockChangedCondition.signalAll();
        }
        catch (Exception e) {
            this.status = new RequestStatus(RequestStatusCode.ERROR);
            this.exception.set(new JoynrRuntimeException(e));
        }
        finally {
            this.statusLock.unlock();
        }
    }

    public void onFailure(JoynrException newException) {
        this.status = new RequestStatus(RequestStatusCode.ERROR);
        try {
            this.statusLock.lock();
            this.exception.set(newException);
            this.statusLockChangedCondition.signalAll();
        }
        finally {
            this.statusLock.unlock();
        }
    }

    public void resolve(Object ... outParameters) {
        if (outParameters.length == 0) {
            this.onSuccess(null);
        } else {
            this.onSuccess(outParameters[0]);
        }
    }
}

