/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.pubsub;

import io.joynr.subtypes.JoynrType;

public abstract class SubscriptionQos
implements JoynrType {
    private static final long serialVersionUID = 1L;
    private long expiryDateMs = 0L;
    public static final int IGNORE_VALUE = -1;
    public static final long INFINITE_SUBSCRIPTION = 0x1FFFFFFFFFFFFFL;
    public static final long NO_EXPIRY_DATE = 0L;

    public long getExpiryDateMs() {
        return this.expiryDateMs;
    }

    public SubscriptionQos setExpiryDateMs(long expiryDateMs) {
        long now = System.currentTimeMillis();
        if (expiryDateMs <= now && expiryDateMs != 0L) {
            throw new IllegalArgumentException("Subscription ExpiryDate " + expiryDateMs + " in the past. Now: " + now);
        }
        this.expiryDateMs = expiryDateMs;
        return this;
    }

    public SubscriptionQos setValidityMs(long validityMs) {
        if (validityMs == -1L) {
            this.setExpiryDateMs(0L);
        } else {
            long now = System.currentTimeMillis();
            this.expiryDateMs = now + validityMs;
        }
        return this;
    }

    public void clearExpiryDate() {
        this.expiryDateMs = 0L;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.expiryDateMs ^ this.expiryDateMs >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubscriptionQos other = (SubscriptionQos)obj;
        return this.expiryDateMs == other.expiryDateMs;
    }
}

