/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ObjectMapper {
    private final com.fasterxml.jackson.databind.ObjectMapper realObjectMapper;
    private final Set<Class<?>> registeredSubtypes;
    private final ReentrantReadWriteLock lock;

    public ObjectMapper() {
        this(new com.fasterxml.jackson.databind.ObjectMapper());
    }

    public ObjectMapper(ObjectMapper other) {
        this.realObjectMapper = other.realObjectMapper.copy();
        this.registeredSubtypes = new HashSet(other.registeredSubtypes);
        this.lock = new ReentrantReadWriteLock();
    }

    ObjectMapper(com.fasterxml.jackson.databind.ObjectMapper realObjectMapper) {
        Objects.requireNonNull(realObjectMapper);
        this.realObjectMapper = realObjectMapper;
        this.registeredSubtypes = new HashSet();
        this.lock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readValue(JsonParser p, Class<T> valueType) throws IOException {
        this.lock.readLock().lock();
        try {
            Object object = this.realObjectMapper.readValue(p, valueType);
            return (T)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readValue(URL src, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        this.lock.readLock().lock();
        try {
            Object object = this.realObjectMapper.readValue(src, valueType);
            return (T)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readValue(String content, Class<T> valueType) throws JsonProcessingException, JsonMappingException {
        this.lock.readLock().lock();
        try {
            Object object = this.realObjectMapper.readValue(content, valueType);
            return (T)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readValue(String content, TypeReference<T> valueTypeRef) throws JsonProcessingException, JsonMappingException {
        this.lock.readLock().lock();
        try {
            Object object = this.realObjectMapper.readValue(content, valueTypeRef);
            return (T)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T treeToValue(TreeNode n, Class<T> valueType) throws IllegalArgumentException, JsonProcessingException {
        this.lock.readLock().lock();
        try {
            Object object = this.realObjectMapper.treeToValue(n, valueType);
            return (T)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public <T extends JsonNode> T valueToTree(Object fromValue) throws IllegalArgumentException {
        this.lock.readLock().lock();
        try {
            JsonNode jsonNode = this.realObjectMapper.valueToTree(fromValue);
            return (T)jsonNode;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String writeValueAsString(Object value) throws JsonProcessingException {
        this.lock.readLock().lock();
        try {
            String string = this.realObjectMapper.writeValueAsString(value);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T convertValue(Object fromValue, Class<T> toValueType) throws IllegalArgumentException {
        this.lock.readLock().lock();
        try {
            Object object = this.realObjectMapper.convertValue(fromValue, toValueType);
            return (T)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) throws IllegalArgumentException {
        this.lock.readLock().lock();
        try {
            Object object = this.realObjectMapper.convertValue(fromValue, toValueTypeRef);
            return (T)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T convertValue(Object fromValue, JavaType toValueType) throws IllegalArgumentException {
        this.lock.readLock().lock();
        try {
            Object object = this.realObjectMapper.convertValue(fromValue, toValueType);
            return (T)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Deprecated
    public void enableDefaultTypingAsProperty(ObjectMapper.DefaultTyping applicability, String propertyName) {
        this.lock.writeLock().lock();
        try {
            this.realObjectMapper.enableDefaultTypingAsProperty(applicability, propertyName);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateDefaultTypingAsProperty(PolymorphicTypeValidator ptv, ObjectMapper.DefaultTyping applicability, String propertyName) {
        this.lock.writeLock().lock();
        try {
            this.realObjectMapper.activateDefaultTypingAsProperty(ptv, applicability, propertyName);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void configure(SerializationFeature f, boolean state) {
        this.lock.writeLock().lock();
        try {
            this.realObjectMapper.configure(f, state);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void configure(DeserializationFeature f, boolean state) {
        this.lock.writeLock().lock();
        try {
            this.realObjectMapper.configure(f, state);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void configure(MapperFeature f, boolean state) {
        this.lock.writeLock().lock();
        try {
            this.realObjectMapper.configure(f, state);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configOverrideSetInclude(Class<?> clazz, JsonInclude.Include value, JsonInclude.Include content) {
        this.lock.writeLock().lock();
        try {
            this.realObjectMapper.configOverride(clazz).setInclude(JsonInclude.Value.construct((JsonInclude.Include)value, (JsonInclude.Include)content));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public SerializationConfig getSerializationConfig() {
        this.lock.readLock().lock();
        try {
            SerializationConfig serializationConfig = this.realObjectMapper.getSerializationConfig();
            return serializationConfig;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public DeserializationConfig getDeserializationConfig() {
        this.lock.readLock().lock();
        try {
            DeserializationConfig deserializationConfig = this.realObjectMapper.getDeserializationConfig();
            return deserializationConfig;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void registerModule(Module module) {
        this.lock.writeLock().lock();
        try {
            this.realObjectMapper.registerModule(module);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void registerSubtypes(Class<?> ... classes) {
        this.lock.readLock().lock();
        try {
            classes = (Class[])Arrays.asList(classes).stream().filter(c -> !this.registeredSubtypes.contains(c)).toArray(Class[]::new);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (0 != classes.length) {
            this.lock.writeLock().lock();
            try {
                this.realObjectMapper.registerSubtypes((Class[])classes);
                this.registeredSubtypes.addAll(Arrays.asList(classes));
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readValue(byte[] src, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        this.lock.readLock().lock();
        try {
            Object object = this.realObjectMapper.readValue(src, valueType);
            return (T)object;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public JsonNode readTree(InputStream in) throws IOException {
        this.lock.readLock().lock();
        try {
            JsonNode jsonNode = this.realObjectMapper.readTree(in);
            return jsonNode;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

