/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MultiMap<K, V>
implements Serializable {
    private final Map<K, Set<V>> storage = new HashMap<K, Set<V>>();

    public boolean containsKey(K key) {
        return this.storage.containsKey(key);
    }

    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    public Set<V> get(K key) {
        if (!this.containsKey(key)) {
            return new HashSet();
        }
        return this.storage.get(key);
    }

    public void put(K key, V value) {
        Set<V> set = this.storage.get(key);
        if (set == null) {
            set = new HashSet<V>();
            this.storage.put(key, set);
        }
        set.add(value);
    }

    public boolean remove(K key, V value) {
        Set<V> set = this.storage.get(key);
        if (set != null) {
            boolean removed = set.remove(value);
            if (removed && set.isEmpty()) {
                this.storage.remove(key);
            }
            return removed;
        }
        return false;
    }

    public void removeAll(K key) {
        this.storage.remove(key);
    }

    public Set<K> keySet() {
        return this.storage.keySet();
    }

    public int size() {
        return this.storage.values().stream().mapToInt(Set::size).sum();
    }
}

