/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.exceptions;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.exceptions.JoynrRuntimeException;

public class JoynrDelayMessageException
extends JoynrRuntimeException {
    private static final long serialVersionUID = 1L;
    private static final long DEFAULT_DELAY_MS = 1000L;
    @Inject(optional=true)
    @Named(value="joynr.messaging.sendmsgretryintervalms")
    private long delayMs = 1000L;

    public JoynrDelayMessageException(String reason) {
        super(reason);
    }

    public JoynrDelayMessageException(long delayMs, String reason) {
        this(reason);
        this.delayMs = delayMs;
    }

    public JoynrDelayMessageException(long delayMs, String reason, Throwable cause) {
        super(reason, cause);
        this.delayMs = delayMs;
    }

    public JoynrDelayMessageException(String reason, Throwable cause) {
        super(reason, cause);
    }

    public long getDelayMs() {
        return this.delayMs;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.delayMs ^ this.delayMs >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JoynrDelayMessageException other = (JoynrDelayMessageException)obj;
        return this.delayMs == other.delayMs;
    }
}

