/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.provider;

import io.joynr.provider.SubscriptionPublisher;
import io.joynr.provider.SubscriptionPublisherObservable;
import io.joynr.pubsub.publication.AttributeListener;
import io.joynr.pubsub.publication.BroadcastFilter;
import io.joynr.pubsub.publication.BroadcastFilterImpl;
import io.joynr.pubsub.publication.BroadcastListener;
import io.joynr.pubsub.publication.MulticastListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSubscriptionPublisher
implements SubscriptionPublisherObservable,
SubscriptionPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSubscriptionPublisher.class);
    ConcurrentHashMap<String, List<AttributeListener>> attributeListeners = new ConcurrentHashMap();
    ConcurrentHashMap<String, List<BroadcastListener>> broadcastListeners = new ConcurrentHashMap();
    List<MulticastListener> multicastListeners = new ArrayList<MulticastListener>();
    protected ConcurrentHashMap<String, List<BroadcastFilter>> broadcastFilters = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onAttributeValueChanged(String attributeName, Object value) {
        List<AttributeListener> listeners;
        if (!this.attributeListeners.containsKey(attributeName)) {
            return;
        }
        List<AttributeListener> list = listeners = this.attributeListeners.get(attributeName);
        synchronized (list) {
            for (AttributeListener listener : listeners) {
                listener.attributeValueChanged(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireBroadcast(String broadcastName, List<BroadcastFilter> broadcastFilters, Object ... values) {
        List<BroadcastListener> listeners;
        if (!this.broadcastListeners.containsKey(broadcastName)) {
            return;
        }
        List<BroadcastListener> list = listeners = this.broadcastListeners.get(broadcastName);
        synchronized (list) {
            for (BroadcastListener listener : listeners) {
                listener.broadcastOccurred(broadcastFilters, values);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireMulticast(String multicastName, String[] partitions, Object ... values) {
        ArrayList<MulticastListener> listeners;
        List<MulticastListener> list = this.multicastListeners;
        synchronized (list) {
            listeners = new ArrayList<MulticastListener>(this.multicastListeners);
        }
        for (MulticastListener listener : listeners) {
            listener.multicastOccurred(multicastName, partitions, values);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerAttributeListener(String attributeName, AttributeListener attributeListener) {
        List<AttributeListener> listeners;
        this.attributeListeners.putIfAbsent(attributeName, new ArrayList());
        List<AttributeListener> list = listeners = this.attributeListeners.get(attributeName);
        synchronized (list) {
            listeners.add(attributeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterAttributeListener(String attributeName, AttributeListener attributeListener) {
        List<AttributeListener> listeners = this.attributeListeners.get(attributeName);
        if (listeners == null) {
            LOG.error("trying to unregister an attribute listener for attribute \"" + attributeName + "\" that was never registered");
            return;
        }
        List<AttributeListener> list = listeners;
        synchronized (list) {
            boolean success = listeners.remove(attributeListener);
            if (!success) {
                LOG.error("trying to unregister an attribute listener for attribute \"" + attributeName + "\" that was never registered");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerBroadcastListener(String broadcastName, BroadcastListener broadcastListener) {
        List<BroadcastListener> listeners;
        this.broadcastListeners.putIfAbsent(broadcastName, new ArrayList());
        List<BroadcastListener> list = listeners = this.broadcastListeners.get(broadcastName);
        synchronized (list) {
            listeners.add(broadcastListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterBroadcastListener(String broadcastName, BroadcastListener broadcastListener) {
        List<BroadcastListener> listeners = this.broadcastListeners.get(broadcastName);
        if (listeners == null) {
            LOG.error("trying to unregister a listener for broadcast \"" + broadcastName + "\" that was never registered");
            return;
        }
        List<BroadcastListener> list = listeners;
        synchronized (list) {
            boolean success = listeners.remove(broadcastListener);
            if (!success) {
                LOG.error("trying to unregister a listener for broadcast \"" + broadcastName + "\" that was never registered");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerMulticastListener(MulticastListener multicastListener) {
        List<MulticastListener> list = this.multicastListeners;
        synchronized (list) {
            this.multicastListeners.add(multicastListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterMulticastListener(MulticastListener multicastListener) {
        List<MulticastListener> list = this.multicastListeners;
        synchronized (list) {
            this.multicastListeners.remove(multicastListener);
        }
    }

    @Override
    public void addBroadcastFilter(BroadcastFilterImpl filter) {
        if (this.broadcastFilters.containsKey(filter.getName())) {
            this.broadcastFilters.get(filter.getName()).add(filter);
        } else {
            ArrayList<BroadcastFilterImpl> list = new ArrayList<BroadcastFilterImpl>();
            list.add(filter);
            this.broadcastFilters.put(filter.getName(), list);
        }
    }

    @Override
    public void addBroadcastFilter(BroadcastFilterImpl ... filters) {
        List<BroadcastFilterImpl> filtersList = Arrays.asList(filters);
        for (BroadcastFilterImpl filter : filtersList) {
            this.addBroadcastFilter(filter);
        }
    }
}

