/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.provider;

import io.joynr.exceptions.JoynrException;
import io.joynr.provider.PromiseListener;
import java.util.Arrays;
import javax.annotation.CheckForNull;

public class PromiseKeeper
implements PromiseListener {
    private State state = State.PENDING;
    private Object[] values = null;
    private JoynrException error = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFulfillment(Object ... values) {
        PromiseKeeper promiseKeeper = this;
        synchronized (promiseKeeper) {
            this.values = values;
            this.state = State.FULFILLED;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRejection(JoynrException error) {
        PromiseKeeper promiseKeeper = this;
        synchronized (promiseKeeper) {
            this.error = error;
            this.state = State.REJECTED;
            this.notifyAll();
        }
    }

    @CheckForNull
    public Object[] getValues() throws InterruptedException {
        return this.getValues(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public Object[] getValues(long timeout) throws InterruptedException {
        if (!this.isSettled()) {
            PromiseKeeper promiseKeeper = this;
            synchronized (promiseKeeper) {
                this.wait(timeout);
            }
        }
        if (this.values == null) {
            return null;
        }
        return Arrays.copyOf(this.values, this.values.length);
    }

    @CheckForNull
    public JoynrException getError() throws InterruptedException {
        return this.getError(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public JoynrException getError(long timeout) throws InterruptedException {
        if (!this.isSettled()) {
            PromiseKeeper promiseKeeper = this;
            synchronized (promiseKeeper) {
                this.wait(timeout);
            }
        }
        return this.error;
    }

    public void waitForSettlement() throws InterruptedException {
        this.waitForSettlement(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForSettlement(long timeout) throws InterruptedException {
        if (!this.isSettled()) {
            PromiseKeeper promiseKeeper = this;
            synchronized (promiseKeeper) {
                this.wait(timeout);
            }
        }
    }

    public boolean isFulfilled() {
        return this.state == State.FULFILLED;
    }

    public boolean isRejected() {
        return this.state == State.REJECTED;
    }

    public boolean isSettled() {
        return this.isFulfilled() || this.isRejected();
    }

    private static enum State {
        PENDING,
        FULFILLED,
        REJECTED;

    }
}

