/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.name.Names;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.jeeintegration.CallbackHandlerDiscovery;
import io.joynr.jeeintegration.JoynrRuntimeFactory;
import io.joynr.jeeintegration.ProviderWrapper;
import io.joynr.jeeintegration.ServiceProviderDiscovery;
import io.joynr.jeeintegration.api.ProviderDomain;
import io.joynr.jeeintegration.api.ProviderRegistrationSettingsFactory;
import io.joynr.jeeintegration.api.ServiceProvider;
import io.joynr.jeeintegration.messaging.JeeSharedSubscriptionsMqttMessagingSkeleton;
import io.joynr.messaging.MessagingSkeletonFactory;
import io.joynr.provider.JoynrProvider;
import io.joynr.proxy.Future;
import io.joynr.runtime.JoynrRuntime;
import io.joynr.runtime.ProviderRegistrar;
import io.joynr.runtime.ShutdownNotifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.DependsOn;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import joynr.exceptions.ApplicationException;
import joynr.infrastructure.GlobalCapabilitiesDirectoryProvider;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.MqttAddress;
import joynr.types.ProviderQos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Startup
@DependsOn(value={"JeeJoynrServiceLocator"})
public class JoynrIntegrationBean {
    private static final Logger logger = LoggerFactory.getLogger(JoynrIntegrationBean.class);
    private BeanManager beanManager;
    private JoynrRuntimeFactory joynrRuntimeFactory;
    private ServiceProviderDiscovery serviceProviderDiscovery;
    private CallbackHandlerDiscovery callbackHandlerDiscovery;
    private Set<Object> registeredProviders = new HashSet<Object>();
    private JoynrRuntime joynrRuntime;

    public JoynrIntegrationBean() {
    }

    @Inject
    public JoynrIntegrationBean(BeanManager beanManager, JoynrRuntimeFactory joynrRuntimeFactory, ServiceProviderDiscovery serviceProviderDiscovery, CallbackHandlerDiscovery callbackHandlerDiscovery) {
        this.beanManager = beanManager;
        this.joynrRuntimeFactory = joynrRuntimeFactory;
        this.serviceProviderDiscovery = serviceProviderDiscovery;
        this.callbackHandlerDiscovery = callbackHandlerDiscovery;
    }

    @PostConstruct
    public void initialise() {
        logger.debug("Initializing joynr integration bean");
        Set<Bean<?>> serviceProviderBeans = this.serviceProviderDiscovery.findServiceProviderBeans();
        this.joynrRuntime = this.joynrRuntimeFactory.create(this.getServiceProviderInterfaceClasses(serviceProviderBeans));
        this.registerProviders(serviceProviderBeans, this.joynrRuntime);
        this.registerCallbackHandlers(this.joynrRuntime);
        boolean sharedSubscriptionsEnabled = (Boolean)this.getJoynrInjector().getInstance(Key.get(Boolean.class, (Annotation)Names.named((String)"joynr.messaging.mqtt.enable.sharedsubscriptions")));
        if (sharedSubscriptionsEnabled) {
            this.subscribeToSharedSubscriptionsTopic();
        }
    }

    private void subscribeToSharedSubscriptionsTopic() {
        String[] gbids = (String[])this.getJoynrInjector().getInstance(Key.get(String[].class, (Annotation)Names.named((String)"joynr.internal.messaging.gbidArray")));
        MessagingSkeletonFactory factory = (MessagingSkeletonFactory)this.getJoynrInjector().getInstance(MessagingSkeletonFactory.class);
        Arrays.stream(gbids).forEach(gbid -> {
            Optional skeleton = factory.getSkeleton((Address)new MqttAddress(gbid, ""));
            if (!skeleton.isPresent()) {
                throw new IllegalStateException("No skeleton for GBID " + gbid);
            }
            if (!JeeSharedSubscriptionsMqttMessagingSkeleton.class.isInstance(skeleton.get())) {
                throw new IllegalStateException("Skeleton for GBID " + gbid + " is not of type JeeSharedSubscriptionsMqttMessagingSkeleton");
            }
            ((JeeSharedSubscriptionsMqttMessagingSkeleton)((Object)((Object)JeeSharedSubscriptionsMqttMessagingSkeleton.class.cast(skeleton.get())))).subscribeToSharedTopic();
        });
    }

    private void registerCallbackHandlers(JoynrRuntime joynrRuntime) {
        this.callbackHandlerDiscovery.forEach(callbackBean -> joynrRuntime.registerStatelessAsyncCallback(callbackBean));
    }

    private void registerProviders(Set<Bean<?>> serviceProviderBeans, JoynrRuntime runtime) {
        int maxRetryCount = (Integer)this.getJoynrInjector().getInstance(Key.get(Integer.class, (Annotation)Names.named((String)"joynr.jeeintegration.registration.retries")));
        int retryIntervalMs = (Integer)this.getJoynrInjector().getInstance(Key.get(Integer.class, (Annotation)Names.named((String)"joynr.jeeintegration.registration.retryintervalms")));
        boolean awaitRegistration = (Boolean)this.getJoynrInjector().getInstance(Key.get(Boolean.class, (Annotation)Names.named((String)"joynr.jeeintegration.awaitregistration")));
        Set<ProviderRegistrationSettingsFactory> providerSettingsFactories = this.getProviderRegistrationSettingsFactories();
        for (Bean<?> bean : serviceProviderBeans) {
            Class beanClass = bean.getBeanClass();
            Class<?> serviceInterface = beanClass.getAnnotation(ServiceProvider.class).serviceInterface();
            Class<?> providerInterface = this.serviceProviderDiscovery.getProviderInterfaceFor(serviceInterface);
            if (logger.isDebugEnabled()) {
                logger.debug("Provider registration started: registering the bean {} as provider {} for service {}.", new Object[]{bean, providerInterface, serviceInterface});
            }
            JoynrProvider provider = (JoynrProvider)Proxy.newProxyInstance(beanClass.getClassLoader(), new Class[]{providerInterface, JoynrProvider.class}, (InvocationHandler)new ProviderWrapper(bean, this.beanManager, this.joynrRuntimeFactory.getInjector()));
            ProviderQos providerQos = null;
            String[] gbids = null;
            String domain = null;
            for (ProviderRegistrationSettingsFactory factory : providerSettingsFactories) {
                if (!factory.providesFor(serviceInterface, beanClass)) continue;
                providerQos = factory.createProviderQos();
                gbids = factory.createGbids();
                domain = factory.createDomain();
                break;
            }
            if (providerQos == null) {
                providerQos = new ProviderQos();
            }
            if (gbids == null) {
                gbids = new String[]{};
            }
            if (domain == null) {
                domain = this.getDomainForProvider(beanClass);
            }
            ProviderRegistrar registrar = runtime.getProviderRegistrar(domain, provider).withProviderQos(providerQos).withGbids(gbids);
            if (!awaitRegistration) {
                logger.debug("Provider registration: trigger registration, bean {}", bean);
                registrar.register();
                continue;
            }
            if (!GlobalCapabilitiesDirectoryProvider.class.equals(providerInterface)) {
                logger.debug("Provider registration: awaitGlobalRegistration, bean {}", bean);
                registrar.awaitGlobalRegistration();
            }
            int attempt = 1;
            while (true) {
                logger.debug("Provider registration: attempt #{}, bean {}", (Object)attempt, bean);
                Future registrationFuture = registrar.register();
                try {
                    try {
                        registrationFuture.get(71000L);
                        logger.info("Provider registration succeeded: attempt #{}, bean {}.", (Object)attempt, bean);
                        break;
                    }
                    catch (JoynrRuntimeException | ApplicationException e) {
                        if (attempt > maxRetryCount) {
                            logger.error("Provider registration failed, giving up: attempt #{}, bean {}.", new Object[]{attempt, bean, e});
                            throw new JoynrRuntimeException("Provider registration failed for bean " + bean, e);
                        }
                        logger.warn("Provider registration failed, retrying in {} ms...: attempt #{}, bean {} (error: {})", new Object[]{retryIntervalMs, attempt, bean, e.toString()});
                        ++attempt;
                        Thread.sleep(retryIntervalMs);
                    }
                }
                catch (InterruptedException e) {
                    throw new JoynrRuntimeException("Provider registration failed for bean " + bean, (Throwable)e);
                }
            }
            this.registeredProviders.add(provider);
        }
    }

    private String getDomainForProvider(Class<?> beanClass) {
        ProviderDomain providerDomain = beanClass.getAnnotation(ProviderDomain.class);
        String domain = providerDomain != null ? providerDomain.value() : this.joynrRuntimeFactory.getLocalDomain();
        return domain;
    }

    private Set<ProviderRegistrationSettingsFactory> getProviderRegistrationSettingsFactories() {
        Set providerSettingsFactoryBeans = this.beanManager.getBeans(ProviderRegistrationSettingsFactory.class, new Annotation[]{new AnnotationLiteral<Any>(){}});
        HashSet<ProviderRegistrationSettingsFactory> providerSettingsFactories = new HashSet<ProviderRegistrationSettingsFactory>();
        for (Bean providerSettingsFactoryBean : providerSettingsFactoryBeans) {
            ProviderRegistrationSettingsFactory factory = (ProviderRegistrationSettingsFactory)providerSettingsFactoryBean.create(this.beanManager.createCreationalContext((Contextual)providerSettingsFactoryBean));
            providerSettingsFactories.add(factory);
        }
        return providerSettingsFactories;
    }

    @PreDestroy
    public void destroy() {
        if (!((Boolean)this.getJoynrInjector().getInstance(Key.get(Boolean.class, (Annotation)Names.named((String)"joynr.messaging.mqtt.enable.sharedsubscriptions")))).booleanValue()) {
            logger.info("Unregistering provider ", (Object)this.joynrRuntimeFactory.getLocalDomain());
            for (Object provider : this.registeredProviders) {
                try {
                    this.joynrRuntime.unregisterProvider(this.joynrRuntimeFactory.getLocalDomain(), provider);
                }
                catch (Exception e) {
                    logger.error("Error unregistering provider", (Throwable)e);
                }
            }
        }
        ShutdownNotifier shutdownNotifier = (ShutdownNotifier)this.getJoynrInjector().getInstance(ShutdownNotifier.class);
        shutdownNotifier.shutdown();
    }

    public Injector getJoynrInjector() {
        return this.joynrRuntimeFactory.getInjector();
    }

    private Set<Class<?>> getServiceProviderInterfaceClasses(Set<Bean<?>> serviceProviderBeans) {
        HashSet result = new HashSet();
        for (Bean<?> bean : serviceProviderBeans) {
            result.add(bean.getBeanClass().getAnnotation(ServiceProvider.class).serviceInterface());
        }
        return result;
    }

    public JoynrRuntime getRuntime() {
        return this.joynrRuntime;
    }
}

