/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.jeeintegration.multicast;

import io.joynr.jeeintegration.api.SubscriptionPublisher;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.ejb.Singleton;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SubscriptionPublisherProducer {
    private static final Logger logger = LoggerFactory.getLogger(SubscriptionPublisherProducer.class);
    private ConcurrentMap<Class<?>, io.joynr.provider.SubscriptionPublisher> subscriptionPublishers = new ConcurrentHashMap();

    @Produces
    @SubscriptionPublisher
    public io.joynr.provider.SubscriptionPublisher getSubscriptionPublisher(InjectionPoint injectionPoint) {
        logger.info("Looking for subscription publisher for: {}", (Object)injectionPoint);
        logger.trace("Type {}, Member {}, Annotated {} ", new Object[]{injectionPoint.getType(), injectionPoint.getMember(), injectionPoint.getAnnotated()});
        final Class beanClass = injectionPoint.getBean() == null ? injectionPoint.getMember().getDeclaringClass() : injectionPoint.getBean().getBeanClass();
        logger.info("Bean class is: {}", (Object)beanClass);
        if (!this.subscriptionPublishers.containsKey(beanClass)) {
            final Class subscriptionPublisherClass = (Class)injectionPoint.getAnnotated().getBaseType();
            io.joynr.provider.SubscriptionPublisher newSubscriptionPublisher = (io.joynr.provider.SubscriptionPublisher)Proxy.newProxyInstance(subscriptionPublisherClass.getClassLoader(), new Class[]{subscriptionPublisherClass}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    throw new IllegalStateException("No subscription publisher set for " + subscriptionPublisherClass + " on " + beanClass);
                }
            });
            this.subscriptionPublishers.putIfAbsent(beanClass, newSubscriptionPublisher);
        }
        return (io.joynr.provider.SubscriptionPublisher)this.subscriptionPublishers.get(beanClass);
    }

    public void add(io.joynr.provider.SubscriptionPublisher subscriptionPublisher, Class forBeanClass) {
        this.subscriptionPublishers.put(forBeanClass, subscriptionPublisher);
    }
}

